@extends('layouts.modern')

@section('title', 'تفاصيل القسط')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>تفاصيل القسط #{{ $installment->id }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('invoice-installments.index') }}">الأقساط</a></li>
                        <li class="breadcrumb-item active">تفاصيل القسط #{{ $installment->id }}</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <!-- بطاقة تفاصيل القسط -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">معلومات القسط</h3>
                            <div class="card-tools">
                                <a href="{{ route('invoices.show', $installment->invoice_id) }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-file-invoice"></i> عرض الفاتورة
                                </a>
                                @if(!$installment->isPaid())
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#recordPaymentModal">
                                        <i class="fas fa-money-bill-wave"></i> تسجيل دفعة
                                    </button>
                                @endif
                                @can('edit_installment')
                                    <a href="{{ route('invoice-installments.edit', $installment->id) }}" class="btn btn-warning btn-sm">
                                        <i class="fas fa-edit"></i> تعديل
                                    </a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">رقم القسط</span>
                                            <span class="info-box-number text-muted mb-0">{{ $installment->id }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">رقم الفاتورة</span>
                                            <span class="info-box-number text-muted mb-0">{{ $installment->invoice->invoice_number }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">العميل</span>
                                            <span class="info-box-number text-muted mb-0">{{ $installment->invoice->customer->name }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">تاريخ الاستحقاق</span>
                                            <span class="info-box-number text-muted mb-0">{{ $installment->due_date->format('Y-m-d') }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-4">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">المبلغ الكلي</span>
                                            <span class="info-box-number text-muted mb-0">{{ number_format($installment->amount, 2) }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">المبلغ المدفوع</span>
                                            <span class="info-box-number text-muted mb-0">{{ number_format($installment->paid_amount, 2) }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">المبلغ المتبقي</span>
                                            <span class="info-box-number text-muted mb-0">{{ number_format($installment->getRemainingAmount(), 2) }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">الحالة</span>
                                            <span class="info-box-number text-muted mb-0">
                                                {!! $installment->getStatusLabel() !!}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-muted">الوقت المتبقي</span>
                                            <span class="info-box-number text-muted mb-0">{{ $installment->getDaysRemainingOrOverdue() }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <div class="progress">
                                        <div class="progress-bar {{ $installment->isPaid() ? 'bg-success' : ($installment->isOverdue() ? 'bg-danger' : 'bg-info') }}" 
                                             role="progressbar" 
                                             style="width: {{ $installment->getPaymentProgressPercentage() }}%;" 
                                             aria-valuenow="{{ $installment->getPaymentProgressPercentage() }}" 
                                             aria-valuemin="0" 
                                             aria-valuemax="100">
                                            {{ $installment->getPaymentProgressPercentage() }}%
                                        </div>
                                    </div>
                                    <div class="mt-2 text-center">
                                        <small>
                                            {{ number_format($installment->paid_amount, 2) }} ريال من أصل {{ number_format($installment->amount, 2) }} ريال
                                        </small>
                                    </div>
                                </div>
                            </div>

                            @if($installment->notes)
                                <div class="row mt-3">
                                    <div class="col-md-12">
                                        <div class="info-box bg-light">
                                            <div class="info-box-content">
                                                <span class="info-box-text text-muted">ملاحظات</span>
                                                <span class="info-box-number text-muted mb-0">{{ $installment->notes }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                    <!-- /.card -->

                    <!-- بطاقة سجل المدفوعات -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">سجل المدفوعات</h3>
                        </div>
                        <div class="card-body">
                            @if($installment->payments->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>تاريخ الدفع</th>
                                                <th>المبلغ</th>
                                                <th>طريقة الدفع</th>
                                                <th>رقم المرجع</th>
                                                <th>ملاحظات</th>
                                                <th>بواسطة</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($installment->payments as $payment)
                                                <tr>
                                                    <td>{{ $payment->id }}</td>
                                                    <td>{{ $payment->payment_date->format('Y-m-d') }}</td>
                                                    <td>{{ number_format($payment->amount, 2) }}</td>
                                                    <td>{{ $payment->paymentMethod->name ?? 'غير محدد' }}</td>
                                                    <td>{{ $payment->reference_number ?? '-' }}</td>
                                                    <td>{{ $payment->notes ?? '-' }}</td>
                                                    <td>{{ $payment->createdBy->name ?? 'غير محدد' }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-info">
                                    لا توجد مدفوعات مسجلة لهذا القسط.
                                </div>
                            @endif
                        </div>
                    </div>
                    <!-- /.card -->
                </div>

                <div class="col-md-4">
                    <!-- بطاقة معلومات العميل -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">معلومات العميل</h3>
                        </div>
                        <div class="card-body">
                            <div class="text-center mb-3">
                                <img class="profile-user-img img-fluid img-circle" 
                                     src="{{ $installment->invoice->customer->profile_image ? asset('storage/' . $installment->invoice->customer->profile_image) : asset('img/default-user.png') }}" 
                                     alt="صورة العميل">
                            </div>
                            <h3 class="profile-username text-center">{{ $installment->invoice->customer->name }}</h3>
                            <p class="text-muted text-center">{{ $installment->invoice->customer->customer_type }}</p>

                            <ul class="list-group list-group-unbordered mb-3">
                                <li class="list-group-item">
                                    <b>رقم الهاتف</b> <a class="float-left">{{ $installment->invoice->customer->phone }}</a>
                                </li>
                                <li class="list-group-item">
                                    <b>البريد الإلكتروني</b> <a class="float-left">{{ $installment->invoice->customer->email ?? 'غير متوفر' }}</a>
                                </li>
                                <li class="list-group-item">
                                    <b>العنوان</b> <a class="float-left">{{ $installment->invoice->customer->address ?? 'غير متوفر' }}</a>
                                </li>
                            </ul>

                            <a href="{{ route('customers.show', $installment->invoice->customer_id) }}" class="btn btn-primary btn-block">
                                <i class="fas fa-user"></i> عرض ملف العميل
                            </a>
                        </div>
                    </div>
                    <!-- /.card -->

                    <!-- بطاقة الأقساط الأخرى -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">أقساط أخرى للفاتورة</h3>
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                @foreach($otherInstallments as $otherInstallment)
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <a href="{{ route('invoice-installments.show', $otherInstallment->id) }}">
                                                القسط #{{ $otherInstallment->id }}
                                            </a>
                                            <br>
                                            <small class="text-muted">{{ $otherInstallment->due_date->format('Y-m-d') }}</small>
                                        </div>
                                        <div>
                                            <span class="badge badge-primary">{{ number_format($otherInstallment->amount, 2) }}</span>
                                            {!! $otherInstallment->getStatusLabel() !!}
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <!-- /.card -->

                    <!-- بطاقة الإجراءات -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">الإجراءات</h3>
                        </div>
                        <div class="card-body">
                            @if(!$installment->isPaid())
                                <button type="button" class="btn btn-primary btn-block mb-2" data-toggle="modal" data-target="#recordPaymentModal">
                                    <i class="fas fa-money-bill-wave"></i> تسجيل دفعة
                                </button>
                            @endif

                            @can('send_installment_reminder')
                                <form action="{{ route('invoice-installments.send-reminder', $installment->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-warning btn-block mb-2" {{ $installment->isPaid() ? 'disabled' : '' }}>
                                        <i class="fas fa-bell"></i> إرسال تذكير للعميل
                                    </button>
                                </form>
                            @endcan

                            @can('edit_installment')
                                <a href="{{ route('invoice-installments.edit', $installment->id) }}" class="btn btn-info btn-block mb-2">
                                    <i class="fas fa-edit"></i> تعديل القسط
                                </a>
                            @endcan

                            @can('delete_installment')
                                <button type="button" class="btn btn-danger btn-block" data-toggle="modal" data-target="#deleteModal">
                                    <i class="fas fa-trash"></i> حذف القسط
                                </button>
                            @endcan
                        </div>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>

@include('invoice_installments.payment_form', ['installment' => $installment, 'paymentMethods' => $paymentMethods])

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأكيد حذف القسط</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من رغبتك في حذف القسط #{{ $installment->id }}؟</p>
                <p class="text-danger">تحذير: لا يمكن التراجع عن هذا الإجراء!</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                <form action="{{ route('invoice-installments.destroy', $installment->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        // تنسيق الجدول
        $('.table').DataTable({
            "paging": false,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": false,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.22/i18n/Arabic.json"
            }
        });
    });
</script>
@endsection