@extends('layouts.modern')

@section('title', 'إرسال تذكيرات الأقساط')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>إرسال تذكيرات الأقساط</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('invoice-installments.index') }}">الأقساط</a></li>
                        <li class="breadcrumb-item active">إرسال تذكيرات الأقساط</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="row">
                <!-- الأقساط المستحقة قريباً -->
                <div class="col-md-6">
                    <div class="card card-warning">
                        <div class="card-header">
                            <h3 class="card-title">الأقساط المستحقة خلال 7 أيام</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الفاتورة</th>
                                            <th>العميل</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ</th>
                                            <th>الأيام المتبقية</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($upcomingInstallments as $installment)
                                            <tr>
                                                <td>{{ $installment->id }}</td>
                                                <td>
                                                    <a href="{{ route('invoices.show', $installment->invoice_id) }}" target="_blank">
                                                        {{ $installment->invoice->invoice_number }}
                                                    </a>
                                                </td>
                                                <td>{{ $installment->invoice->customer->name }}</td>
                                                <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($installment->amount, 2) }}</td>
                                                <td>{{ $installment->due_date->diffInDays(now()) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center">لا توجد أقساط مستحقة خلال 7 أيام</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-3">
                                <form action="{{ route('invoice-installments.send-upcoming-reminders') }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-warning btn-block {{ $upcomingInstallments->isEmpty() ? 'disabled' : '' }}" {{ $upcomingInstallments->isEmpty() ? 'disabled' : '' }}>
                                        <i class="fas fa-bell mr-2"></i> إرسال تذكيرات للأقساط المستحقة قريباً ({{ $upcomingInstallments->count() }})
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- الأقساط المتأخرة -->
                <div class="col-md-6">
                    <div class="card card-danger">
                        <div class="card-header">
                            <h3 class="card-title">الأقساط المتأخرة</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الفاتورة</th>
                                            <th>العميل</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ</th>
                                            <th>أيام التأخير</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($overdueInstallments as $installment)
                                            <tr>
                                                <td>{{ $installment->id }}</td>
                                                <td>
                                                    <a href="{{ route('invoices.show', $installment->invoice_id) }}" target="_blank">
                                                        {{ $installment->invoice->invoice_number }}
                                                    </a>
                                                </td>
                                                <td>{{ $installment->invoice->customer->name }}</td>
                                                <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($installment->amount, 2) }}</td>
                                                <td>{{ now()->diffInDays($installment->due_date) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center">لا توجد أقساط متأخرة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-3">
                                <form action="{{ route('invoice-installments.send-overdue-reminders') }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-danger btn-block {{ $overdueInstallments->isEmpty() ? 'disabled' : '' }}" {{ $overdueInstallments->isEmpty() ? 'disabled' : '' }}>
                                        <i class="fas fa-exclamation-triangle mr-2"></i> إرسال تذكيرات للأقساط المتأخرة ({{ $overdueInstallments->count() }})
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- معلومات إضافية -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">معلومات عن التذكيرات</h3>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <h5><i class="icon fas fa-info"></i> معلومات عن التذكيرات</h5>
                                <ul>
                                    <li>يتم إرسال التذكيرات للعملاء عبر البريد الإلكتروني والرسائل النصية (إذا كانت متاحة).</li>
                                    <li>يتم إرسال نسخة من التذكيرات للمستخدمين المسؤولين عن متابعة الأقساط.</li>
                                    <li>يمكن إرسال التذكيرات يدوياً من هذه الصفحة أو تلقائياً عبر المهام المجدولة.</li>
                                    <li>يتم تسجيل جميع التذكيرات المرسلة في سجل الإشعارات.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        // تنسيق الجداول
        $('.table').DataTable({
            "paging": false,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": false,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.22/i18n/Arabic.json"
            }
        });
    });
</script>
@endsection