@extends('layouts.modern')

@section('title', 'تقارير الأقساط')

@section('styles')
<style>
    .stats-card {
        transition: all 0.3s;
    }
    .stats-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    .chart-container {
        position: relative;
        height: 300px;
        margin-bottom: 20px;
    }
</style>
@endsection

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>تقارير الأقساط</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('invoice-installments.index') }}">الأقساط</a></li>
                        <li class="breadcrumb-item active">تقارير الأقساط</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- إحصائيات الأقساط -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info stats-card">
                        <div class="inner">
                            <h3>{{ number_format($stats['total_count']) }}</h3>
                            <p>إجمالي الأقساط</p>
                            <h5>{{ number_format($stats['total_amount'], 2) }} ريال</h5>
                        </div>
                        <div class="icon">
                            <i class="fas fa-money-check-alt"></i>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success stats-card">
                        <div class="inner">
                            <h3>{{ number_format($stats['paid_count']) }}</h3>
                            <p>الأقساط المدفوعة</p>
                            <h5>{{ number_format($stats['paid_amount'], 2) }} ريال</h5>
                        </div>
                        <div class="icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning stats-card">
                        <div class="inner">
                            <h3>{{ number_format($stats['pending_count']) }}</h3>
                            <p>الأقساط المستحقة</p>
                            <h5>{{ number_format($stats['pending_amount'], 2) }} ريال</h5>
                        </div>
                        <div class="icon">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger stats-card">
                        <div class="inner">
                            <h3>{{ number_format($stats['overdue_count']) }}</h3>
                            <p>الأقساط المتأخرة</p>
                            <h5>{{ number_format($stats['overdue_amount'], 2) }} ريال</h5>
                        </div>
                        <div class="icon">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- الرسوم البيانية -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">الأقساط حسب الشهر</h3>
                        </div>
                        <div class="card-body">
                            <div class="chart-container">
                                <canvas id="monthlyChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">الأقساط حسب العميل (أعلى 10 عملاء)</h3>
                        </div>
                        <div class="card-body">
                            <div class="chart-container">
                                <canvas id="customerChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- روابط التقارير التفصيلية -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">التقارير التفصيلية</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <a href="{{ route('invoice-installments.upcoming-report') }}" class="btn btn-warning btn-block btn-lg mb-3">
                                        <i class="fas fa-calendar-alt mr-2"></i> تقرير الأقساط المستحقة قريباً
                                    </a>
                                </div>
                                <div class="col-md-4">
                                    <a href="{{ route('invoice-installments.overdue-report') }}" class="btn btn-danger btn-block btn-lg mb-3">
                                        <i class="fas fa-exclamation-triangle mr-2"></i> تقرير الأقساط المتأخرة
                                    </a>
                                </div>
                                <div class="col-md-4">
                                    <a href="{{ route('invoice-installments.index') }}" class="btn btn-info btn-block btn-lg mb-3">
                                        <i class="fas fa-list mr-2"></i> قائمة جميع الأقساط
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(function () {
        // رسم بياني للأقساط حسب الشهر
        var monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
        var monthlyChart = new Chart(monthlyCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($chartData['months']) !!},
                datasets: [{
                    label: 'إجمالي الأقساط',
                    data: {!! json_encode($chartData['amounts']) !!},
                    backgroundColor: 'rgba(60, 141, 188, 0.7)',
                    borderColor: 'rgba(60, 141, 188, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        // رسم بياني للأقساط حسب العميل
        var customerCtx = document.getElementById('customerChart').getContext('2d');
        var customerChart = new Chart(customerCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($customerChartData['customers']) !!},
                datasets: [
                    {
                        label: 'إجمالي الأقساط',
                        data: {!! json_encode($customerChartData['total']) !!},
                        backgroundColor: 'rgba(60, 141, 188, 0.7)',
                        borderColor: 'rgba(60, 141, 188, 1)',
                        borderWidth: 1
                    },
                    {
                        label: 'المدفوع',
                        data: {!! json_encode($customerChartData['paid']) !!},
                        backgroundColor: 'rgba(40, 167, 69, 0.7)',
                        borderColor: 'rgba(40, 167, 69, 1)',
                        borderWidth: 1
                    },
                    {
                        label: 'المتبقي',
                        data: {!! json_encode($customerChartData['due']) !!},
                        backgroundColor: 'rgba(220, 53, 69, 0.7)',
                        borderColor: 'rgba(220, 53, 69, 1)',
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    },
                    x: {
                        ticks: {
                            maxRotation: 45,
                            minRotation: 45
                        }
                    }
                }
            }
        });
    });
</script>
@endsection