@extends('layouts.modern')

@section('title', 'تسجيل دفعات الأقساط')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>تسجيل دفعات الأقساط</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('invoice-installments.index') }}">الأقساط</a></li>
                        <li class="breadcrumb-item active">تسجيل دفعات الأقساط</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">الأقساط المستحقة للدفع</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            @if(session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                            @endif

                            @if(session('error'))
                                <div class="alert alert-danger">
                                    {{ session('error') }}
                                </div>
                            @endif

                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الفاتورة</th>
                                            <th>العميل</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ الكلي</th>
                                            <th>المبلغ المدفوع</th>
                                            <th>المبلغ المتبقي</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($pendingInstallments as $installment)
                                            <tr>
                                                <td>{{ $installment->id }}</td>
                                                <td>
                                                    <a href="{{ route('invoices.show', $installment->invoice_id) }}" target="_blank">
                                                        {{ $installment->invoice->invoice_number }}
                                                    </a>
                                                </td>
                                                <td>{{ $installment->invoice->customer->name }}</td>
                                                <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($installment->amount, 2) }}</td>
                                                <td>{{ number_format($installment->paid_amount, 2) }}</td>
                                                <td>{{ number_format($installment->amount - $installment->paid_amount, 2) }}</td>
                                                <td>
                                                    @if($installment->status == 'pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                    @elseif($installment->status == 'overdue')
                                                        <span class="badge badge-danger">متأخر</span>
                                                    @elseif($installment->status == 'partially_paid')
                                                        <span class="badge badge-info">مدفوع جزئياً</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#paymentModal{{ $installment->id }}">
                                                        <i class="fas fa-money-bill-wave"></i> تسجيل دفعة
                                                    </button>
                                                </td>
                                            </tr>

                                            <!-- Payment Modal -->
                                            <div class="modal fade" id="paymentModal{{ $installment->id }}" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel{{ $installment->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="paymentModalLabel{{ $installment->id }}">تسجيل دفعة للقسط #{{ $installment->id }}</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('invoice-installments.record-payment', $installment->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="amount">المبلغ المدفوع</label>
                                                                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" value="{{ $installment->amount - $installment->paid_amount }}" max="{{ $installment->amount - $installment->paid_amount }}" required>
                                                                    <small class="form-text text-muted">المبلغ المتبقي: {{ number_format($installment->amount - $installment->paid_amount, 2) }}</small>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="payment_date">تاريخ الدفع</label>
                                                                    <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="payment_method_id">طريقة الدفع</label>
                                                                    <select class="form-control" id="payment_method_id" name="payment_method_id" required>
                                                                        <option value="">-- اختر طريقة الدفع --</option>
                                                                        @foreach($paymentMethods as $method)
                                                                            <option value="{{ $method->id }}">{{ $method->name }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="reference_number">رقم المرجع</label>
                                                                    <input type="text" class="form-control" id="reference_number" name="reference_number">
                                                                    <small class="form-text text-muted">رقم الشيك، رقم التحويل، إلخ.</small>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="notes">ملاحظات</label>
                                                                    <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-primary">تسجيل الدفعة</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty
                                            <tr>
                                                <td colspan="9" class="text-center">لا توجد أقساط مستحقة للدفع</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-4">
                                {{ $pendingInstallments->links() }}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        // تنسيق الجدول
        $('.table').DataTable({
            "paging": false,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": false,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.22/i18n/Arabic.json"
            }
        });
    });
</script>
@endsection