<!-- نموذج تسجيل دفعة لقسط -->
<div class="modal fade" id="recordPaymentModal" tabindex="-1" role="dialog" aria-labelledby="recordPaymentModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('invoice-installments.record-payment', $installment->id) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="recordPaymentModalLabel">تسجيل دفعة للقسط #{{ $installment->id }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="amount">المبلغ المدفوع <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" step="0.01" min="0.01" max="{{ $installment->getRemainingAmount() }}" class="form-control" id="amount" name="amount" value="{{ old('amount', $installment->getRemainingAmount()) }}" required>
                            <div class="input-group-append">
                                <span class="input-group-text">ريال</span>
                            </div>
                        </div>
                        <small class="form-text text-muted">المبلغ المتبقي: {{ number_format($installment->getRemainingAmount(), 2) }} ريال</small>
                    </div>
                    <div class="form-group">
                        <label for="payment_date">تاريخ الدفع <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ old('payment_date', date('Y-m-d')) }}" required>
                    </div>
                    <div class="form-group">
                        <label for="payment_method_id">طريقة الدفع <span class="text-danger">*</span></label>
                        <select class="form-control" id="payment_method_id" name="payment_method_id" required>
                            <option value="">-- اختر طريقة الدفع --</option>
                            @foreach($paymentMethods as $method)
                                <option value="{{ $method->id }}" {{ old('payment_method_id') == $method->id ? 'selected' : '' }}>{{ $method->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="reference_number">رقم المرجع</label>
                        <input type="text" class="form-control" id="reference_number" name="reference_number" value="{{ old('reference_number') }}">
                        <small class="form-text text-muted">رقم الشيك، رقم التحويل، إلخ.</small>
                    </div>
                    <div class="form-group">
                        <label for="notes">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تسجيل الدفعة</button>
                </div>
            </form>
        </div>
    </div>
</div>