@extends('layouts.modern')

@section('title', 'أقساط الفواتير')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>أقساط الفواتير</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item active">أقساط الفواتير</li>
                </ol>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">قائمة أقساط الفواتير</h3>
                        <div class="card-tools">
                            @can('create_invoice_installment')
                                <a href="{{ route('invoice-installments.create') }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> إضافة قسط جديد
                                </a>
                            @endcan
                        </div>
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                            <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                                {{ session('success') }}
                            </div>
                        @endif
                        
                        @if(session('error'))
                            <div class="alert alert-danger alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                                {{ session('error') }}
                            </div>
                        @endif
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم الفاتورة</th>
                                        <th>العميل</th>
                                        <th>المبلغ</th>
                                        <th>تاريخ الاستحقاق</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($installments as $installment)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>
                                                <a href="{{ route('invoices.show', $installment->invoice_id) }}">
                                                    {{ $installment->invoice->invoice_number }}
                                                </a>
                                            </td>
                                            <td>{{ $installment->invoice->customer->name }}</td>
                                            <td>{{ number_format($installment->amount, 2) }}</td>
                                            <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                            <td>
                                                @if($installment->status == 'pending')
                                                    <span class="badge badge-warning">قيد الانتظار</span>
                                                @elseif($installment->status == 'paid')
                                                    <span class="badge badge-success">مدفوع</span>
                                                @elseif($installment->status == 'overdue')
                                                    <span class="badge badge-danger">متأخر</span>
                                                @elseif($installment->status == 'partially_paid')
                                                    <span class="badge badge-info">مدفوع جزئياً</span>
                                                @elseif($installment->status == 'cancelled')
                                                    <span class="badge badge-secondary">ملغي</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ $installment->status }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ route('invoice-installments.show', $installment->id) }}" class="btn btn-info btn-sm">
                                                        <i class="fas fa-eye"></i> عرض
                                                    </a>
                                                    
                                                    @can('edit_invoice_installment')
                                                        <a href="{{ route('invoice-installments.edit', $installment->id) }}" class="btn btn-warning btn-sm">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    @endcan
                                                    
                                                    @can('delete_invoice_installment')
                                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-modal-{{ $installment->id }}">
                                                            <i class="fas fa-trash"></i> حذف
                                                        </button>
                                                    @endcan
                                                </div>
                                                
                                                <!-- Modal -->
                                                <div class="modal fade" id="delete-modal-{{ $installment->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-modal-label" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="delete-modal-label">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من حذف قسط الفاتورة رقم <strong>{{ $installment->id }}</strong>؟
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <form action="{{ route('invoice-installments.destroy', $installment->id) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">لا توجد أقساط فواتير</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-4">
                            {{ $installments->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection