@extends('layouts.modern')

@section('title', 'لوحة معلومات الأقساط')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لوحة معلومات الأقساط</h3>
                    <div class="card-tools">
                        <a href="{{ route('invoice-installments.overdue-report') }}" class="btn btn-sm btn-danger">
                            <i class="fas fa-exclamation-circle ml-1"></i> الأقساط المتأخرة
                        </a>
                        <a href="{{ route('invoice-installments.upcoming-report') }}" class="btn btn-sm btn-warning">
                            <i class="fas fa-clock ml-1"></i> الأقساط المستحقة قريباً
                        </a>
                        <a href="{{ route('invoice-installments.update-overdue') }}" class="btn btn-sm btn-info" 
                           onclick="return confirm('هل أنت متأكد من تحديث حالة الأقساط المتأخرة؟')">
                            <i class="fas fa-sync ml-1"></i> تحديث الأقساط المتأخرة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- إحصائيات الأقساط -->
                        <div class="col-md-3">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total'] }}</h3>
                                    <p>إجمالي الأقساط</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['paid'] }}</h3>
                                    <p>الأقساط المدفوعة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['pending'] }}</h3>
                                    <p>الأقساط قيد الانتظار</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $stats['overdue'] }}</h3>
                                    <p>الأقساط المتأخرة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <!-- الأقساط المستحقة خلال الأسبوع القادم -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">الأقساط المستحقة خلال الأسبوع القادم</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>رقم القسط</th>
                                                    <th>رقم الفاتورة</th>
                                                    <th>العميل</th>
                                                    <th>المبلغ</th>
                                                    <th>تاريخ الاستحقاق</th>
                                                    <th>الأيام المتبقية</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($upcomingInstallments as $installment)
                                                <tr>
                                                    <td>{{ $installment->id }}</td>
                                                    <td>
                                                        <a href="{{ route('invoices.show', $installment->invoice_id) }}">
                                                            {{ $installment->invoice->invoice_number }}
                                                        </a>
                                                    </td>
                                                    <td>{{ $installment->invoice->customer->name }}</td>
                                                    <td>{{ number_format($installment->amount, 2) }}</td>
                                                    <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                                    <td>{{ $installment->getDaysRemainingOrOverdue() }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- الأقساط المتأخرة -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">الأقساط المتأخرة</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>رقم القسط</th>
                                                    <th>رقم الفاتورة</th>
                                                    <th>العميل</th>
                                                    <th>المبلغ</th>
                                                    <th>تاريخ الاستحقاق</th>
                                                    <th>مدة التأخير</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($overdueInstallments as $installment)
                                                <tr>
                                                    <td>{{ $installment->id }}</td>
                                                    <td>
                                                        <a href="{{ route('invoices.show', $installment->invoice_id) }}">
                                                            {{ $installment->invoice->invoice_number }}
                                                        </a>
                                                    </td>
                                                    <td>{{ $installment->invoice->customer->name }}</td>
                                                    <td>{{ number_format($installment->amount, 2) }}</td>
                                                    <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                                    <td>{{ $installment->getDaysRemainingOrOverdue() }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <!-- رسم بياني للأقساط حسب الشهر -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">الأقساط حسب الشهر</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="installmentsByMonthChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- رسم بياني للأقساط حسب الحالة -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">الأقساط حسب الحالة</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="installmentsByStatusChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // رسم بياني للأقساط حسب الشهر
        var monthlyCtx = document.getElementById('installmentsByMonthChart').getContext('2d');
        var monthlyChart = new Chart(monthlyCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($chartData['months']) !!},
                datasets: [{
                    label: 'المبلغ الإجمالي',
                    data: {!! json_encode($chartData['amounts']) !!},
                    backgroundColor: 'rgba(60, 141, 188, 0.8)',
                    borderColor: 'rgba(60, 141, 188, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // رسم بياني للأقساط حسب الحالة
        var statusCtx = document.getElementById('installmentsByStatusChart').getContext('2d');
        var statusChart = new Chart(statusCtx, {
            type: 'pie',
            data: {
                labels: ['مدفوع', 'قيد الانتظار', 'متأخر'],
                datasets: [{
                    data: [
                        {{ $stats['paid'] }},
                        {{ $stats['pending'] }},
                        {{ $stats['overdue'] }}
                    ],
                    backgroundColor: [
                        'rgba(40, 167, 69, 0.8)',
                        'rgba(255, 193, 7, 0.8)',
                        'rgba(220, 53, 69, 0.8)'
                    ],
                    borderColor: [
                        'rgba(40, 167, 69, 1)',
                        'rgba(255, 193, 7, 1)',
                        'rgba(220, 53, 69, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true
            }
        });
    });
</script>
@endsection