@extends('layouts.app')

@section('title', 'تفاصيل إذن الصرف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل إذن الصرف #{{ $inventoryIssue->issue_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory-issues.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @if($inventoryIssue->status != 'completed')
                            <a href="{{ route('inventory-issues.edit', $inventoryIssue->id) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <form action="{{ route('inventory-issues.complete', $inventoryIssue->id) }}" method="POST" style="display: inline-block;">
                                @csrf
                                @method('PATCH')
                                <button type="submit" class="btn btn-success" onclick="return confirm('هل أنت متأكد من اعتماد هذا الإذن؟')">
                                    <i class="fas fa-check"></i> اعتماد
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات إذن الصرف</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الإذن</th>
                                            <td>{{ $inventoryIssue->issue_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>الشركة</th>
                                            <td>{{ $inventoryIssue->company->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المخزن</th>
                                            <td>{{ $inventoryIssue->warehouse->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإصدار</th>
                                            <td>{{ $inventoryIssue->issue_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                <span class="badge {{ $inventoryIssue->status == 'completed' ? 'badge-success' : 'badge-warning' }}">
                                                    {{ $inventoryIssue->status_text }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاعتماد</th>
                                            <td>{{ $inventoryIssue->completed_at ? $inventoryIssue->completed_at->format('Y-m-d H:i') : 'غير معتمد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $inventoryIssue->user->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $inventoryIssue->notes ?: 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات أمر الشغل</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم أمر الشغل</th>
                                            <td>{{ $inventoryIssue->workOrder->order_number ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم المصعد</th>
                                            <td>{{ $inventoryIssue->workOrder->elevator->elevator_number ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المرحلة</th>
                                            <td>{{ $inventoryIssue->workOrder->phase->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة أمر الشغل</th>
                                            <td>{{ $inventoryIssue->workOrder->status ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">بنود إذن الصرف</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>كود الصنف</th>
                                                    <th>اسم الصنف</th>
                                                    <th>الكمية</th>
                                                    <th>ملاحظات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($inventoryIssue->items as $index => $item)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $item->inventoryItem->code ?? 'غير محدد' }}</td>
                                                        <td>{{ $item->inventoryItem->name ?? 'غير محدد' }}</td>
                                                        <td>{{ $item->quantity }}</td>
                                                        <td>{{ $item->notes ?: 'لا توجد ملاحظات' }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="5" class="text-center">لا توجد بنود</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection