@extends('layouts.app')

@section('title', 'أذونات صرف المخازن')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">أذونات صرف المخازن</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory-issues.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إنشاء إذن صرف جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم الإذن</th>
                                    <th>الشركة</th>
                                    <th>رقم أمر الشغل</th>
                                    <th>رقم المصعد</th>
                                    <th>المخزن</th>
                                    <th>تاريخ الإصدار</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($inventoryIssues as $issue)
                                    <tr>
                                        <td>{{ $issue->issue_number }}</td>
                                        <td>{{ $issue->company->name ?? 'غير محدد' }}</td>
                                        <td>{{ $issue->workOrder->order_number ?? 'غير محدد' }}</td>
                                        <td>{{ $issue->workOrder->elevator->elevator_number ?? 'غير محدد' }}</td>
                                        <td>{{ $issue->warehouse->name ?? 'غير محدد' }}</td>
                                        <td>{{ $issue->issue_date->format('Y-m-d') }}</td>
                                        <td>
                                            <span class="badge {{ $issue->status == 'completed' ? 'badge-success' : 'badge-warning' }}">
                                                {{ $issue->status_text }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('inventory-issues.show', $issue->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> عرض
                                                </a>
                                                @if($issue->status != 'completed')
                                                    <a href="{{ route('inventory-issues.edit', $issue->id) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i> تعديل
                                                    </a>
                                                    <form action="{{ route('inventory-issues.destroy', $issue->id) }}" method="POST" style="display: inline-block;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الإذن؟')">
                                                            <i class="fas fa-trash"></i> حذف
                                                        </button>
                                                    </form>
                                                @endif
                                                @if($issue->status != 'completed')
                                                    <form action="{{ route('inventory-issues.complete', $issue->id) }}" method="POST" style="display: inline-block;">
                                                        @csrf
                                                        @method('PATCH')
                                                        <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('هل أنت متأكد من إكمال هذا الإذن؟')">
                                                            <i class="fas fa-check"></i> إكمال
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد أذونات صرف</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $inventoryIssues->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection