@extends('layouts.app')

@section('title', 'تعديل إذن الصرف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل إذن الصرف #{{ $inventoryIssue->issue_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory-issues.show', $inventoryIssue->id) }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للتفاصيل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('inventory-issues.update', $inventoryIssue->id) }}" method="POST" id="issueForm">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="work_order_id">أمر الشغل <span class="text-danger">*</span></label>
                                    <select name="work_order_id" id="work_order_id" class="form-control @error('work_order_id') is-invalid @enderror" required>
                                        <option value="">-- اختر أمر الشغل --</option>
                                        @foreach($workOrders as $workOrder)
                                            <option value="{{ $workOrder->id }}" {{ old('work_order_id', $inventoryIssue->work_order_id) == $workOrder->id ? 'selected' : '' }}>
                                                {{ $workOrder->order_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('work_order_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="warehouse_id">المخزن <span class="text-danger">*</span></label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control @error('warehouse_id') is-invalid @enderror" required>
                                        <option value="">-- اختر المخزن --</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id', $inventoryIssue->warehouse_id) == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!-- حقل مخفي للشركة -->
                            <input type="hidden" name="company_id" id="company_id" value="{{ $inventoryIssue->company_id }}">
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="elevator_number">رقم المصعد</label>
                                    <input type="text" id="elevator_number" class="form-control" value="{{ $inventoryIssue->workOrder->elevator->elevator_number ?? '' }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="phase_name">المرحلة</label>
                                    <input type="text" id="phase_name" class="form-control" value="{{ $inventoryIssue->workOrder->phase->name ?? '' }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="issue_date">تاريخ الإصدار <span class="text-danger">*</span></label>
                                    <input type="date" name="issue_date" id="issue_date" class="form-control @error('issue_date') is-invalid @enderror" value="{{ old('issue_date', $inventoryIssue->issue_date->format('Y-m-d')) }}" required>
                                    @error('issue_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $inventoryIssue->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h4>بنود إذن الصرف</h4>

                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead>
                                    <tr>
                                        <th>الصنف</th>
                                        <th>الوحدة</th>
                                        <th>الكمية</th>
                                        <th>ملاحظات</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id="item-row-template" style="display: none;">
                                        <td>
                                            <select name="items[0][inventory_item_id]" class="form-control inventory-item-select" required>
                                                <option value="">-- اختر الصنف --</option>
                                                @foreach($inventoryItems as $item)
                                                    <option value="{{ $item->id }}">{{ $item->name }} ({{ $item->code }})</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td>
                                            <select name="items[0][unit_id]" class="form-control unit-select" required>
                                                <option value="">-- اختر الوحدة --</option>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="number" name="items[0][quantity]" class="form-control" step="0.01" min="0.01" required>
                                        </td>
                                        <td>
                                            <input type="text" name="items[0][notes]" class="form-control">
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-sm remove-item">
                                                <i class="fas fa-trash"></i> حذف
                                            </button>
                                        </td>
                                    </tr>
                                    
                                    @foreach($inventoryIssue->items as $index => $item)
                                        <tr>
                                            <td>
                                                <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                                <select name="items[{{ $index }}][inventory_item_id]" class="form-control inventory-item-select" required>
                                                    <option value="">-- اختر الصنف --</option>
                                                    @foreach($inventoryItems as $inventoryItem)
                                                        <option value="{{ $inventoryItem->id }}" {{ $item->inventory_item_id == $inventoryItem->id ? 'selected' : '' }}>
                                                            {{ $inventoryItem->name }} ({{ $inventoryItem->code }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>
                                                <select name="items[{{ $index }}][unit_id]" class="form-control unit-select" required>
                                                    <option value="">-- اختر الوحدة --</option>
                                                    @foreach($inventoryUnits as $unit)
                                                        @if($unit->inventory_item_id == $item->inventory_item_id)
                                                            <option value="{{ $unit->id }}" {{ $item->unit_id == $unit->id ? 'selected' : '' }}>
                                                                {{ $unit->name }}
                                                            </option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>
                                                <input type="number" name="items[{{ $index }}][quantity]" class="form-control" step="0.01" min="0.01" value="{{ $item->quantity }}" required>
                                            </td>
                                            <td>
                                                <input type="text" name="items[{{ $index }}][notes]" class="form-control" value="{{ $item->notes }}">
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-danger btn-sm remove-item">
                                                    <i class="fas fa-trash"></i> حذف
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="4">
                                            <button type="button" class="btn btn-success btn-sm" id="add-item">
                                                <i class="fas fa-plus"></i> إضافة صنف
                                            </button>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التعديلات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // متغير لتتبع عدد البنود
        let itemCount = {{ count($inventoryIssue->items) }};
        
        // تخزين وحدات الأصناف
        const inventoryItemUnits = @json($inventoryItemUnits);

        // إضافة بند جديد
        $('#add-item').click(function() {
            addNewItem();
        });

        // حذف بند
        $(document).on('click', '.remove-item', function() {
            $(this).closest('tr').remove();
            if ($('#items-table tbody tr:visible').length === 0) {
                addNewItem();
            }
        });

        // الحصول على معلومات أمر الشغل
        $('#work_order_id').change(function() {
            const workOrderId = $(this).val();
            if (workOrderId) {
                $.ajax({
                    url: "{{ route('inventory-issues.get-work-order-info') }}",
                    type: "GET",
                    data: { work_order_id: workOrderId },
                    success: function(response) {
                        $('#elevator_number').val(response.elevator_number || '');
                        $('#phase_name').val(response.phase_name || '');
                    },
                    error: function(xhr) {
                        console.error('Error fetching work order info:', xhr.responseText);
                        $('#elevator_number').val('');
                        $('#phase_name').val('');
                    }
                });
            } else {
                $('#elevator_number').val('');
                $('#phase_name').val('');
            }
        });

        // تحميل وحدات الصنف عند اختيار الصنف
        $(document).on('change', '.inventory-item-select', function() {
            const inventoryItemId = $(this).val();
            const unitSelect = $(this).closest('tr').find('.unit-select');
            
            // مسح الوحدات الحالية
            unitSelect.empty();
            unitSelect.append('<option value="">-- اختر الوحدة --</option>');
            
            if (inventoryItemId) {
                // تصفية وحدات الأصناف المرتبطة بالصنف المحدد
                const itemUnits = inventoryItemUnits.filter(itemUnit => itemUnit.item_id == inventoryItemId);
                
                // إضافة الوحدات إلى القائمة المنسدلة
                itemUnits.forEach(itemUnit => {
                    unitSelect.append(`<option value="${itemUnit.unit_id}">${itemUnit.inventory_unit.name}</option>`);
                });
                
                // إذا كانت هناك وحدة واحدة فقط، اختارها تلقائيًا
                if (itemUnits.length === 1) {
                    unitSelect.val(itemUnits[0].unit_id);
                }
                
                // تعيين الوحدة كحقل مطلوب
                unitSelect.attr('required', 'required');
            } else {
                // إزالة خاصية required إذا لم يتم اختيار صنف
                unitSelect.removeAttr('required');
            }
        });

        // دالة لإضافة بند جديد
        function addNewItem() {
            const newRow = $('#item-row-template').clone();
            newRow.removeAttr('id').show();
            
            // تحديث أسماء الحقول بالفهرس الصحيح
            newRow.find('select, input').each(function() {
                const name = $(this).attr('name');
                if (name) {
                    $(this).attr('name', name.replace('[0]', '[' + itemCount + ']'));
                }
            });
            
            $('#items-table tbody').append(newRow);
            itemCount++;
        }

        // التحقق من وجود بنود قبل الإرسال
        $('#issueForm').submit(function(e) {
            if ($('#items-table tbody tr:visible').length === 0) {
                e.preventDefault();
                alert('يجب إضافة صنف واحد على الأقل');
            }
        });
    });
</script>
@endsection