@extends('layouts.modern')

@section('title', 'تفاصيل المستودع')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل المستودع: {{ $warehouse->name }}</h3>
                    <div>
                        <a href="{{ route('inventory.warehouses.edit', $warehouse->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('inventory.warehouses.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 30%">الاسم</th>
                                    <td>{{ $warehouse->name }}</td>
                                </tr>
                                <tr>
                                    <th>الرمز</th>
                                    <td>{{ $warehouse->code }}</td>
                                </tr>
                                <tr>
                                    <th>الفرع</th>
                                    <td>{{ $warehouse->branch ? $warehouse->branch->name : 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>اسم المدير</th>
                                    <td>{{ $warehouse->manager_name ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>رقم الهاتف</th>
                                    <td>{{ $warehouse->phone ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>البريد الإلكتروني</th>
                                    <td>{{ $warehouse->email ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>العنوان</th>
                                    <td>{{ $warehouse->address ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>الحالة</th>
                                    <td>
                                        @if($warehouse->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>ملاحظات</th>
                                    <td>{{ $warehouse->notes ?: 'لا توجد ملاحظات' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">إحصائيات المخزون</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-box bg-info">
                                                <span class="info-box-icon"><i class="fas fa-boxes"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">عدد الأصناف</span>
                                                    <span class="info-box-number">{{ $warehouse->inventory_stocks->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-box bg-success">
                                                <span class="info-box-icon"><i class="fas fa-truck-loading"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">عدد الدفعات</span>
                                                    <span class="info-box-number">{{ $warehouse->batches->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($warehouse->inventory_stocks->count() > 0)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">المخزون الحالي</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الصنف</th>
                                                    <th>الكمية</th>
                                                    <th>الحد الأدنى</th>
                                                    <th>الحالة</th>
                                                    <th>آخر تحديث</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($warehouse->inventory_stocks as $stock)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $stock->item->name }}</td>
                                                    <td>{{ $stock->quantity }} {{ $stock->item->unit }}</td>
                                                    <td>{{ $stock->min_quantity }} {{ $stock->item->unit }}</td>
                                                    <td>
                                                        @if($stock->quantity <= 0)
                                                            <span class="badge bg-danger">نفذ</span>
                                                        @elseif($stock->quantity < $stock->min_quantity)
                                                            <span class="badge bg-warning">منخفض</span>
                                                        @else
                                                            <span class="badge bg-success">متوفر</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ $stock->updated_at->format('Y-m-d H:i') }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection