@extends('layouts.modern')

@section('title', 'تقرير تقييم المخزون')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.valuation.index') }}">تقييم المخزون</a></li>
        <li class="breadcrumb-item active">تقرير التقييم</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">تقرير تقييم المخزون</h3>
                    <div class="card-tools">
                        <button class="btn btn-primary btn-sm" onclick="window.print()">
                            <i class="fa fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('inventory.valuation.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h3 class="card-title">معلومات التقرير</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">تاريخ التقييم</th>
                                            <td>{{ date('Y-m-d', strtotime($asOfDate)) }}</td>
                                        </tr>
                                        <tr>
                                            <th>طريقة التقييم</th>
                                            <td>{{ $valuationMethods[$valuationMethod] }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>{{ $warehouse ? $warehouse->name : 'جميع المستودعات' }}</td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي قيمة المخزون</th>
                                            <td>{{ number_format($totalValue, 2) }} {{ auth()->user()->company->currency }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رمز العنصر</th>
                                    <th>اسم العنصر</th>
                                    <th>الكمية الحالية</th>
                                    <th>وحدة القياس</th>
                                    <th>تكلفة الوحدة</th>
                                    <th>إجمالي التكلفة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($valuationResults as $index => $result)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $result['item']->sku }}</td>
                                        <td>{{ $result['item']->name }}</td>
                                        <td>{{ number_format($result['current_stock'], 2) }}</td>
                                        <td>{{ $result['item']->unit }}</td>
                                        <td>{{ number_format($result['unit_cost'], 2) }} {{ auth()->user()->company->currency }}</td>
                                        <td>{{ number_format($result['total_cost'], 2) }} {{ auth()->user()->company->currency }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا توجد بيانات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="6" class="text-right">إجمالي قيمة المخزون</th>
                                    <th>{{ number_format($totalValue, 2) }} {{ auth()->user()->company->currency }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
<style>
    @media print {
        .main-header, .main-sidebar, .main-footer, .card-tools, .breadcrumb {
            display: none !important;
        }
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        .card {
            box-shadow: none !important;
            border: 1px solid #ddd;
        }
        .card-header {
            background-color: #f8f9fa !important;
            color: #000 !important;
        }
    }
</style>
@endsection