@extends('layouts.modern')

@section('title', 'تقييم المخزون')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item active">تقييم المخزون</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">تقييم المخزون</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card card-primary">
                                <div class="card-header">
                                    <h3 class="card-title">عرض تقرير تقييم المخزون</h3>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('inventory.valuation.report') }}" method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="warehouse_id">المستودع</label>
                                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                                        <option value="">جميع المستودعات</option>
                                                        @foreach($warehouses as $warehouse)
                                                            <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="category_id">فئة المنتجات</label>
                                                    <select name="category_id" id="category_id" class="form-control select2">
                                                        <option value="">جميع الفئات</option>
                                                        @foreach(App\Models\InventoryCategory::where('company_id', auth()->user()->company_id)->get() as $category)
                                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="valuation_method">طريقة التقييم</label>
                                                    <select name="valuation_method" id="valuation_method" class="form-control" required>
                                                        @foreach($valuationMethods as $key => $method)
                                                            <option value="{{ $key }}">{{ $method }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="as_of_date">تاريخ التقييم</label>
                                                    <input type="date" name="as_of_date" id="as_of_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fa fa-search"></i> عرض التقرير
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card card-success">
                                <div class="card-header">
                                    <h3 class="card-title">إنشاء تقييم مخزون جديد</h3>
                                </div>
                                <div class="card-body">
                                    @if(auth()->user()->can('create_inventory_valuation'))
                                        <form action="{{ route('inventory.valuation.store') }}" method="POST">
                                            @csrf
                                            <div class="form-group">
                                                <label for="warehouse_id_create">المستودع</label>
                                                <select name="warehouse_id" id="warehouse_id_create" class="form-control select2">
                                                    <option value="">جميع المستودعات</option>
                                                    @foreach($warehouses as $warehouse)
                                                        <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="valuation_method_create">طريقة التقييم</label>
                                                <select name="valuation_method" id="valuation_method_create" class="form-control" required>
                                                    @foreach($valuationMethods as $key => $method)
                                                        <option value="{{ $key }}">{{ $method }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="valuation_date">تاريخ التقييم</label>
                                                <input type="date" name="valuation_date" id="valuation_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                                            </div>
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-success">
                                                    <i class="fa fa-save"></i> إنشاء تقييم جديد
                                                </button>
                                            </div>
                                            <div class="alert alert-info">
                                                <i class="fa fa-info-circle"></i> سيتم إنشاء تقييم لجميع العناصر في المخزون باستخدام طريقة التقييم المحددة.
                                            </div>
                                        </form>
                                    @else
                                        <div class="alert alert-warning">
                                            <i class="fa fa-exclamation-triangle"></i> ليس لديك صلاحية لإنشاء تقييم مخزون جديد.
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="card card-info mt-4">
                                <div class="card-header">
                                    <h3 class="card-title">سجل التقييم</h3>
                                </div>
                                <div class="card-body">
                                    <a href="{{ route('inventory.valuation.history') }}" class="btn btn-info btn-block">
                                        <i class="fa fa-history"></i> عرض سجل تقييم المخزون
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    $(function () {
        $('.select2').select2();
    });
</script>
@endsection