@extends('layouts.modern')

@section('title', 'سجل تقييم المخزون')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.valuation.index') }}">تقييم المخزون</a></li>
        <li class="breadcrumb-item active">سجل التقييم</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">سجل تقييم المخزون</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.valuation.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>تاريخ التقييم</th>
                                    <th>العنصر</th>
                                    <th>المستودع</th>
                                    <th>الكمية</th>
                                    <th>تكلفة الوحدة</th>
                                    <th>إجمالي التكلفة</th>
                                    <th>طريقة التقييم</th>
                                    <th>بواسطة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($valuations as $index => $valuation)
                                    <tr>
                                        <td>{{ $valuations->firstItem() + $index }}</td>
                                        <td>{{ $valuation->valuation_date->format('Y-m-d') }}</td>
                                        <td>{{ $valuation->item->name }} ({{ $valuation->item->sku }})</td>
                                        <td>{{ $valuation->warehouse->name }}</td>
                                        <td>{{ number_format($valuation->quantity, 2) }} {{ $valuation->item->unit }}</td>
                                        <td>{{ number_format($valuation->unit_cost, 2) }} {{ auth()->user()->company->currency }}</td>
                                        <td>{{ number_format($valuation->total_cost, 2) }} {{ auth()->user()->company->currency }}</td>
                                        <td>
                                            @if($valuation->valuation_method == 'fifo')
                                                الوارد أولاً صادر أولاً (FIFO)
                                            @elseif($valuation->valuation_method == 'lifo')
                                                الوارد أخيراً صادر أولاً (LIFO)
                                            @elseif($valuation->valuation_method == 'average')
                                                متوسط التكلفة (Average Cost)
                                            @endif
                                        </td>
                                        <td>{{ $valuation->creator->name }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد بيانات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $valuations->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection