@extends('layouts.modern')

@section('title', 'تفاصيل حركة المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل حركة المخزون</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.transactions.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للحركات
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">معلومات الحركة</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الحركة</th>
                                            <td>{{ $transaction->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الحركة</th>
                                            <td>
                                                @switch($transaction->transaction_type)
                                                    @case('purchase')
                                                        <span class="badge badge-success">شراء</span>
                                                        @break
                                                    @case('sale')
                                                        <span class="badge badge-info">بيع</span>
                                                        @break
                                                    @case('adjustment')
                                                        <span class="badge badge-warning">تعديل</span>
                                                        @break
                                                    @case('transfer')
                                                        <span class="badge badge-primary">نقل</span>
                                                        @break
                                                    @case('return_to_supplier')
                                                        <span class="badge badge-danger">مرتجع للمورد</span>
                                                        @break
                                                    @case('return_from_customer')
                                                        <span class="badge badge-secondary">مرتجع من العميل</span>
                                                        @break
                                                    @case('maintenance_usage')
                                                        <span class="badge badge-dark">استخدام صيانة</span>
                                                        @break
                                                    @case('write_off')
                                                        <span class="badge badge-danger">شطب</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $transaction->transaction_type }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الحركة</th>
                                            <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>{{ $transaction->warehouse->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        @if($transaction->transaction_type == 'transfer')
                                        <tr>
                                            <th>المستودع الهدف</th>
                                            <td>{{ $transaction->toWarehouse->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>الكمية</th>
                                            <td>
                                                @if($transaction->quantity > 0)
                                                    <span class="text-success">+{{ number_format($transaction->quantity, 2) }}</span>
                                                @else
                                                    <span class="text-danger">{{ number_format($transaction->quantity, 2) }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>سعر الوحدة</th>
                                            <td>{{ $transaction->unit_price ? number_format($transaction->unit_price, 2) : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستخدم</th>
                                            <td>{{ $transaction->creator->name ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">معلومات العنصر</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم العنصر</th>
                                            <td>
                                                <a href="{{ route('inventory.items.show', $transaction->item_id) }}">
                                                    {{ $transaction->item->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الرمز</th>
                                            <td>{{ $transaction->item->sku }}</td>
                                        </tr>
                                        <tr>
                                            <th>الباركود</th>
                                            <td>{{ $transaction->item->barcode ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>التصنيف</th>
                                            <td>{{ $transaction->item->category->name ?? 'غير مصنف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>وحدة القياس</th>
                                            <td>{{ $transaction->item->unit }}</td>
                                        </tr>
                                        <tr>
                                            <th>سعر الشراء</th>
                                            <td>{{ number_format($transaction->item->purchase_price, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>سعر البيع</th>
                                            <td>{{ number_format($transaction->item->selling_price, 2) }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-secondary">
                                    <h3 class="card-title">معلومات المرجع</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 20%">نوع المرجع</th>
                                            <td>
                                                @switch($transaction->reference_type)
                                                    @case('purchase_order')
                                                        أمر شراء
                                                        @break
                                                    @case('invoice')
                                                        فاتورة
                                                        @break
                                                    @case('manual_adjustment')
                                                        تعديل يدوي
                                                        @break
                                                    @case('manual_transfer')
                                                        نقل يدوي
                                                        @break
                                                    @case('maintenance_order')
                                                        أمر صيانة
                                                        @break
                                                    @default
                                                        {{ $transaction->reference_type }}
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>رقم المرجع</th>
                                            <td>
                                                @if($transaction->reference_type == 'purchase_order')
                                                    <a href="{{ route('inventory.purchase-orders.show', $transaction->reference_id) }}">
                                                        {{ $transaction->reference_number }}
                                                    </a>
                                                @elseif($transaction->reference_type == 'invoice')
                                                    <a href="{{ route('invoices.show', $transaction->reference_id) }}">
                                                        {{ $transaction->reference_number }}
                                                    </a>
                                                @elseif($transaction->reference_type == 'maintenance_order')
                                                    <a href="{{ route('maintenance-logs.show', $transaction->reference_id) }}">
                                                        {{ $transaction->reference_number }}
                                                    </a>
                                                @else
                                                    {{ $transaction->reference_number }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $transaction->notes ?? 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($transaction->batch)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">معلومات الدفعة</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 20%">رقم الدفعة</th>
                                            <td>{{ $transaction->batch->batch_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الشراء</th>
                                            <td>{{ $transaction->batch->purchase_date ? $transaction->batch->purchase_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>{{ $transaction->batch->expiry_date ? $transaction->batch->expiry_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المورد</th>
                                            <td>{{ $transaction->batch->supplier->name ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    @if($transaction->serial)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-danger">
                                    <h3 class="card-title">معلومات الرقم التسلسلي</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 20%">الرقم التسلسلي</th>
                                            <td>{{ $transaction->serial->serial_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($transaction->serial->status)
                                                    @case('in_stock')
                                                        <span class="badge badge-success">في المخزون</span>
                                                        @break
                                                    @case('sold')
                                                        <span class="badge badge-info">مباع</span>
                                                        @break
                                                    @case('reserved')
                                                        <span class="badge badge-warning">محجوز</span>
                                                        @break
                                                    @case('defective')
                                                        <span class="badge badge-danger">معيب</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $transaction->serial->status }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الشراء</th>
                                            <td>{{ $transaction->serial->purchase_date ? $transaction->serial->purchase_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المورد</th>
                                            <td>{{ $transaction->serial->supplier->name ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.transactions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للحركات
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection