@extends('layouts.modern')

@section('title', 'حركات المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">حركات المخزون</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.stock.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-cubes"></i> المخزون
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('inventory.transactions.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="warehouse_id" class="mx-1">المستودع:</label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                        <option value="">جميع المستودعات</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ request('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="item_id" class="mx-1">العنصر:</label>
                                    <select name="item_id" id="item_id" class="form-control select2">
                                        <option value="">جميع العناصر</option>
                                        @foreach($items as $item)
                                            <option value="{{ $item->id }}" {{ request('item_id') == $item->id ? 'selected' : '' }}>
                                                {{ $item->name }} ({{ $item->sku }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="transaction_type" class="mx-1">نوع الحركة:</label>
                                    <select name="transaction_type" id="transaction_type" class="form-control">
                                        <option value="">جميع الأنواع</option>
                                        <option value="purchase" {{ request('transaction_type') == 'purchase' ? 'selected' : '' }}>شراء</option>
                                        <option value="sale" {{ request('transaction_type') == 'sale' ? 'selected' : '' }}>بيع</option>
                                        <option value="adjustment" {{ request('transaction_type') == 'adjustment' ? 'selected' : '' }}>تعديل</option>
                                        <option value="transfer" {{ request('transaction_type') == 'transfer' ? 'selected' : '' }}>نقل</option>
                                        <option value="return_to_supplier" {{ request('transaction_type') == 'return_to_supplier' ? 'selected' : '' }}>مرتجع للمورد</option>
                                        <option value="return_from_customer" {{ request('transaction_type') == 'return_from_customer' ? 'selected' : '' }}>مرتجع من العميل</option>
                                        <option value="maintenance_usage" {{ request('transaction_type') == 'maintenance_usage' ? 'selected' : '' }}>استخدام صيانة</option>
                                        <option value="write_off" {{ request('transaction_type') == 'write_off' ? 'selected' : '' }}>شطب</option>
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="date_from" class="mx-1">من تاريخ:</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="date_to" class="mx-1">إلى تاريخ:</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                                
                                <button type="submit" class="btn btn-primary mx-1">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                
                                <a href="{{ route('inventory.transactions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>التاريخ</th>
                                    <th>نوع الحركة</th>
                                    <th>العنصر</th>
                                    <th>المستودع</th>
                                    <th>المستودع الهدف</th>
                                    <th>الكمية</th>
                                    <th>المرجع</th>
                                    <th>المستخدم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $transaction)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        @switch($transaction->transaction_type)
                                            @case('purchase')
                                                <span class="badge badge-success">شراء</span>
                                                @break
                                            @case('sale')
                                                <span class="badge badge-info">بيع</span>
                                                @break
                                            @case('adjustment')
                                                <span class="badge badge-warning">تعديل</span>
                                                @break
                                            @case('transfer')
                                                <span class="badge badge-primary">نقل</span>
                                                @break
                                            @case('return_to_supplier')
                                                <span class="badge badge-danger">مرتجع للمورد</span>
                                                @break
                                            @case('return_from_customer')
                                                <span class="badge badge-secondary">مرتجع من العميل</span>
                                                @break
                                            @case('maintenance_usage')
                                                <span class="badge badge-dark">استخدام صيانة</span>
                                                @break
                                            @case('write_off')
                                                <span class="badge badge-danger">شطب</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary">{{ $transaction->transaction_type }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <a href="{{ route('inventory.items.show', $transaction->item_id) }}">
                                            {{ $transaction->item->name }}
                                        </a>
                                        <br>
                                        <small class="text-muted">{{ $transaction->item->sku }}</small>
                                    </td>
                                    <td>{{ $transaction->warehouse->name ?? 'غير محدد' }}</td>
                                    <td>{{ $transaction->toWarehouse->name ?? '-' }}</td>
                                    <td>
                                        @if($transaction->quantity > 0)
                                            <span class="text-success">+{{ number_format($transaction->quantity, 2) }}</span>
                                        @else
                                            <span class="text-danger">{{ number_format($transaction->quantity, 2) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($transaction->reference_type == 'purchase_order')
                                            <a href="{{ route('inventory.purchase-orders.show', $transaction->reference_id) }}">
                                                {{ $transaction->reference_number }}
                                            </a>
                                        @elseif($transaction->reference_type == 'invoice')
                                            <a href="{{ route('invoices.show', $transaction->reference_id) }}">
                                                {{ $transaction->reference_number }}
                                            </a>
                                        @else
                                            {{ $transaction->reference_number }}
                                        @endif
                                        <br>
                                        <small class="text-muted">{{ $transaction->reference_type }}</small>
                                    </td>
                                    <td>{{ $transaction->creator->name ?? 'غير محدد' }}</td>
                                    <td>
                                        <a href="{{ route('inventory.transactions.show', $transaction->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> عرض
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center">لا توجد بيانات متاحة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $transactions->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        $('.select2').select2();
    });
</script>
@endsection