@extends('layouts.modern')

@section('title', 'تفاصيل المورد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تفاصيل المورد: {{ $supplier->name }}</h3>
                    <div>
                        @if(auth()->user()->hasPermission('edit_suppliers'))
                        <a href="{{ route('inventory.suppliers.edit', $supplier->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endif
                        <a href="{{ route('inventory.suppliers.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">معلومات المورد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الكود</th>
                                            <td>{{ $supplier->code }}</td>
                                        </tr>
                                        <tr>
                                            <th>الاسم</th>
                                            <td>{{ $supplier->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>جهة الاتصال</th>
                                            <td>{{ $supplier->contact_person ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الهاتف</th>
                                            <td>{{ $supplier->phone ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $supplier->email ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الموقع الإلكتروني</th>
                                            <td>
                                                @if($supplier->website)
                                                    <a href="{{ $supplier->website }}" target="_blank">{{ $supplier->website }}</a>
                                                @else
                                                    غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $supplier->address ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم الضريبي</th>
                                            <td>{{ $supplier->tax_number ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>السجل التجاري</th>
                                            <td>{{ $supplier->commercial_register ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($supplier->is_active)
                                                    <span class="badge bg-success">نشط</span>
                                                @else
                                                    <span class="badge bg-danger">غير نشط</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $supplier->notes ?: 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">أوامر الشراء الأخيرة</h5>
                                </div>
                                <div class="card-body">
                                    @if($purchaseOrders->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رقم الأمر</th>
                                                        <th>التاريخ</th>
                                                        <th>الإجمالي</th>
                                                        <th>الحالة</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($purchaseOrders as $order)
                                                    <tr>
                                                        <td>{{ $order->order_number }}</td>
                                                        <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                                        <td>{{ number_format($order->total_amount, 2) }}</td>
                                                        <td>
                                                            @if($order->status == 'draft')
                                                                <span class="badge bg-secondary">مسودة</span>
                                                            @elseif($order->status == 'pending')
                                                                <span class="badge bg-warning">قيد الانتظار</span>
                                                            @elseif($order->status == 'approved')
                                                                <span class="badge bg-info">معتمد</span>
                                                            @elseif($order->status == 'received')
                                                                <span class="badge bg-success">مستلم</span>
                                                            @elseif($order->status == 'cancelled')
                                                                <span class="badge bg-danger">ملغي</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('inventory.purchase-orders.show', $order->id) }}" class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <a href="#" class="btn btn-outline-primary btn-sm mt-2">عرض كل أوامر الشراء</a>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد أوامر شراء لهذا المورد
                                        </div>
                                    @endif
                                </div>
                            </div>

                            @if(isset($supplier->evaluations) && $supplier->evaluations->count() > 0)
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">تقييمات المورد</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>التاريخ</th>
                                                    <th>التقييم</th>
                                                    <th>ملاحظات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($supplier->evaluations as $evaluation)
                                                <tr>
                                                    <td>{{ $evaluation->evaluation_date->format('Y-m-d') }}</td>
                                                    <td>
                                                        @for($i = 1; $i <= 5; $i++)
                                                            @if($i <= $evaluation->rating)
                                                                <i class="fas fa-star text-warning"></i>
                                                            @else
                                                                <i class="far fa-star"></i>
                                                            @endif
                                                        @endfor
                                                    </td>
                                                    <td>{{ $evaluation->notes }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection