@extends('layouts.modern')

@section('title', 'نقل المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">نقل المخزون بين المستودعات</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.stock.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للمخزون
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('inventory.stock.transfer') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="from_warehouse_id">من المستودع <span class="text-danger">*</span></label>
                                    <select name="from_warehouse_id" id="from_warehouse_id" class="form-control select2 @error('from_warehouse_id') is-invalid @enderror" required>
                                        <option value="">اختر المستودع المصدر</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('from_warehouse_id', request('from_warehouse_id')) == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('from_warehouse_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="to_warehouse_id">إلى المستودع <span class="text-danger">*</span></label>
                                    <select name="to_warehouse_id" id="to_warehouse_id" class="form-control select2 @error('to_warehouse_id') is-invalid @enderror" required>
                                        <option value="">اختر المستودع الهدف</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('to_warehouse_id', request('to_warehouse_id')) == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('to_warehouse_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="item_id">العنصر <span class="text-danger">*</span></label>
                                    <select name="item_id" id="item_id" class="form-control select2 @error('item_id') is-invalid @enderror" required>
                                        <option value="">اختر العنصر</option>
                                        @foreach($items as $item)
                                            <option value="{{ $item->id }}" {{ old('item_id', request('item_id')) == $item->id ? 'selected' : '' }}>
                                                {{ $item->name }} ({{ $item->sku }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('item_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="quantity">الكمية <span class="text-danger">*</span></label>
                                    <input type="number" name="quantity" id="quantity" class="form-control @error('quantity') is-invalid @enderror" value="{{ old('quantity') }}" step="0.01" min="0.01" required>
                                    @error('quantity')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-info" id="current-stock-info" style="display: none;">
                                    <h5><i class="icon fas fa-info"></i> معلومات المخزون الحالي</h5>
                                    <div id="stock-details"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-exchange-alt"></i> نقل المخزون
                                </button>
                                <a href="{{ route('inventory.stock.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        $('.select2').select2();
        
        // التحقق من عدم اختيار نفس المستودع
        $('#to_warehouse_id').change(function() {
            var fromWarehouseId = $('#from_warehouse_id').val();
            var toWarehouseId = $(this).val();
            
            if (fromWarehouseId && toWarehouseId && fromWarehouseId === toWarehouseId) {
                alert('لا يمكن النقل إلى نفس المستودع المصدر');
                $(this).val('').trigger('change');
            }
        });
        
        // عند تغيير المستودع المصدر أو العنصر
        $('#from_warehouse_id, #item_id').change(function() {
            checkCurrentStock();
        });
        
        // التحقق من المخزون الحالي
        function checkCurrentStock() {
            var warehouseId = $('#from_warehouse_id').val();
            var itemId = $('#item_id').val();
            
            if (warehouseId && itemId) {
                $.ajax({
                    url: '/api/inventory/check-stock',
                    type: 'GET',
                    data: {
                        warehouse_id: warehouseId,
                        item_id: itemId
                    },
                    success: function(response) {
                        if (response.success) {
                            var stock = response.data;
                            var html = '<p><strong>الكمية الحالية في المستودع المصدر:</strong> ' + stock.quantity + '</p>';
                            html += '<p><strong>الكمية المحجوزة:</strong> ' + stock.reserved_quantity + '</p>';
                            html += '<p><strong>الكمية المتاحة للنقل:</strong> ' + stock.available_quantity + '</p>';
                            
                            $('#stock-details').html(html);
                            $('#current-stock-info').show();
                            
                            // تحديد الحد الأقصى للكمية
                            $('#quantity').attr('max', stock.available_quantity);
                        } else {
                            $('#stock-details').html('<p>لا يوجد مخزون لهذا العنصر في المستودع المصدر.</p>');
                            $('#current-stock-info').show();
                            $('#quantity').attr('max', 0);
                        }
                    },
                    error: function() {
                        $('#current-stock-info').hide();
                    }
                });
            } else {
                $('#current-stock-info').hide();
            }
        }
        
        // التحقق من المخزون عند تحميل الصفحة
        checkCurrentStock();
    });
</script>
@endsection