@extends('layouts.modern')

@section('title', 'إدارة المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إدارة المخزون</h3>
                    <div class="card-tools">
                        @can('adjust_inventory_stock')
                        <a href="{{ route('inventory.stock.adjust-form') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-balance-scale"></i> تعديل المخزون
                        </a>
                        @endcan
                        
                        @can('transfer_inventory_stock')
                        <a href="{{ route('inventory.stock.transfer-form') }}" class="btn btn-info btn-sm">
                            <i class="fas fa-exchange-alt"></i> نقل المخزون
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('inventory.stock.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="warehouse_id" class="mx-1">المستودع:</label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                        <option value="">جميع المستودعات</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ request('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="category_id" class="mx-1">التصنيف:</label>
                                    <select name="category_id" id="category_id" class="form-control select2">
                                        <option value="">جميع التصنيفات</option>
                                        @foreach(\App\Models\InventoryCategory::where('company_id', auth()->user()->company_id)->orderBy('name')->get() as $category)
                                            <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="search" class="mx-1">بحث:</label>
                                    <input type="text" name="search" id="search" class="form-control" value="{{ request('search') }}" placeholder="اسم العنصر، الرمز، الباركود">
                                </div>
                                
                                <button type="submit" class="btn btn-primary mx-1">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                
                                <a href="{{ route('inventory.stock.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المستودع</th>
                                    <th>العنصر</th>
                                    <th>التصنيف</th>
                                    <th>الكمية</th>
                                    <th>الكمية المحجوزة</th>
                                    <th>الكمية المتاحة</th>
                                    <th>سعر الشراء</th>
                                    <th>قيمة المخزون</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stocks as $stock)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $stock->warehouse->name }}</td>
                                    <td>
                                        <a href="{{ route('inventory.items.show', $stock->item_id) }}">
                                            {{ $stock->item->name }}
                                        </a>
                                        <br>
                                        <small class="text-muted">{{ $stock->item->sku }}</small>
                                    </td>
                                    <td>{{ $stock->item->category->name ?? 'غير مصنف' }}</td>
                                    <td>{{ number_format($stock->quantity, 2) }}</td>
                                    <td>{{ number_format($stock->reserved_quantity, 2) }}</td>
                                    <td>{{ number_format($stock->available_quantity, 2) }}</td>
                                    <td>{{ number_format($stock->item->purchase_price, 2) }}</td>
                                    <td>{{ number_format($stock->stock_value, 2) }}</td>
                                    <td>
                                        @if($stock->is_low_stock)
                                            <span class="badge badge-danger">منخفض</span>
                                        @elseif($stock->is_over_stock)
                                            <span class="badge badge-warning">زائد</span>
                                        @else
                                            <span class="badge badge-success">طبيعي</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            @can('adjust_inventory_stock')
                                            <a href="{{ route('inventory.stock.adjust-form') }}?warehouse_id={{ $stock->warehouse_id }}&item_id={{ $stock->item_id }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-balance-scale"></i> تعديل
                                            </a>
                                            @endcan
                                            
                                            @can('transfer_inventory_stock')
                                            <a href="{{ route('inventory.stock.transfer-form') }}?from_warehouse_id={{ $stock->warehouse_id }}&item_id={{ $stock->item_id }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-exchange-alt"></i> نقل
                                            </a>
                                            @endcan
                                            
                                            @can('view_inventory_transactions')
                                            <a href="{{ route('inventory.transactions.index') }}?warehouse_id={{ $stock->warehouse_id }}&item_id={{ $stock->item_id }}" class="btn btn-secondary btn-sm">
                                                <i class="fas fa-history"></i> الحركات
                                            </a>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="11" class="text-center">لا توجد بيانات متاحة</td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="4">الإجمالي</th>
                                    <th>{{ number_format($stocks->sum('quantity'), 2) }}</th>
                                    <th>{{ number_format($stocks->sum('reserved_quantity'), 2) }}</th>
                                    <th>{{ number_format($stocks->sum('quantity') - $stocks->sum('reserved_quantity'), 2) }}</th>
                                    <th></th>
                                    <th>{{ number_format($stocks->sum(function($stock) { return $stock->quantity * $stock->item->purchase_price; }), 2) }}</th>
                                    <th colspan="2"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        $('.select2').select2();
    });
</script>
@endsection