@extends('layouts.modern')

@section('title', 'تعديل المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل المخزون</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.stock.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للمخزون
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('inventory.stock.adjust') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="warehouse_id">المستودع <span class="text-danger">*</span></label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2 @error('warehouse_id') is-invalid @enderror" required>
                                        <option value="">اختر المستودع</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id', request('warehouse_id')) == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="item_id">العنصر <span class="text-danger">*</span></label>
                                    <select name="item_id" id="item_id" class="form-control select2 @error('item_id') is-invalid @enderror" required>
                                        <option value="">اختر العنصر</option>
                                        @foreach($items as $item)
                                            <option value="{{ $item->id }}" {{ old('item_id', request('item_id')) == $item->id ? 'selected' : '' }}>
                                                {{ $item->name }} ({{ $item->sku }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('item_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="adjustment_type">نوع التعديل <span class="text-danger">*</span></label>
                                    <select name="adjustment_type" id="adjustment_type" class="form-control @error('adjustment_type') is-invalid @enderror" required>
                                        <option value="add" {{ old('adjustment_type') == 'add' ? 'selected' : '' }}>إضافة</option>
                                        <option value="subtract" {{ old('adjustment_type') == 'subtract' ? 'selected' : '' }}>خصم</option>
                                        <option value="set" {{ old('adjustment_type') == 'set' ? 'selected' : '' }}>تعيين قيمة محددة</option>
                                    </select>
                                    @error('adjustment_type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="quantity">الكمية <span class="text-danger">*</span></label>
                                    <input type="number" name="quantity" id="quantity" class="form-control @error('quantity') is-invalid @enderror" value="{{ old('quantity') }}" step="0.01" min="0" required>
                                    @error('quantity')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="reason">سبب التعديل <span class="text-danger">*</span></label>
                                    <select name="reason" id="reason" class="form-control @error('reason') is-invalid @enderror" required>
                                        <option value="">اختر السبب</option>
                                        <option value="جرد المخزون" {{ old('reason') == 'جرد المخزون' ? 'selected' : '' }}>جرد المخزون</option>
                                        <option value="تلف" {{ old('reason') == 'تلف' ? 'selected' : '' }}>تلف</option>
                                        <option value="تصحيح خطأ" {{ old('reason') == 'تصحيح خطأ' ? 'selected' : '' }}>تصحيح خطأ</option>
                                        <option value="استخدام داخلي" {{ old('reason') == 'استخدام داخلي' ? 'selected' : '' }}>استخدام داخلي</option>
                                        <option value="هدية" {{ old('reason') == 'هدية' ? 'selected' : '' }}>هدية</option>
                                        <option value="عينة" {{ old('reason') == 'عينة' ? 'selected' : '' }}>عينة</option>
                                        <option value="أخرى" {{ old('reason') == 'أخرى' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('reason')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-info" id="current-stock-info" style="display: none;">
                                    <h5><i class="icon fas fa-info"></i> معلومات المخزون الحالي</h5>
                                    <div id="stock-details"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التعديل
                                </button>
                                <a href="{{ route('inventory.stock.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        $('.select2').select2();
        
        // عند تغيير المستودع أو العنصر
        $('#warehouse_id, #item_id').change(function() {
            checkCurrentStock();
        });
        
        // التحقق من المخزون الحالي
        function checkCurrentStock() {
            var warehouseId = $('#warehouse_id').val();
            var itemId = $('#item_id').val();
            
            if (warehouseId && itemId) {
                $.ajax({
                    url: '/api/inventory/check-stock',
                    type: 'GET',
                    data: {
                        warehouse_id: warehouseId,
                        item_id: itemId
                    },
                    success: function(response) {
                        if (response.success) {
                            var stock = response.data;
                            var html = '<p><strong>الكمية الحالية:</strong> ' + stock.quantity + '</p>';
                            html += '<p><strong>الكمية المحجوزة:</strong> ' + stock.reserved_quantity + '</p>';
                            html += '<p><strong>الكمية المتاحة:</strong> ' + stock.available_quantity + '</p>';
                            
                            $('#stock-details').html(html);
                            $('#current-stock-info').show();
                        } else {
                            $('#stock-details').html('<p>لا يوجد مخزون لهذا العنصر في المستودع المحدد.</p>');
                            $('#current-stock-info').show();
                        }
                    },
                    error: function() {
                        $('#current-stock-info').hide();
                    }
                });
            } else {
                $('#current-stock-info').hide();
            }
        }
        
        // التحقق من المخزون عند تحميل الصفحة
        checkCurrentStock();
    });
</script>
@endsection