@extends('layouts.app')

@section('title', 'تقرير قيمة المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقرير قيمة المخزون</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                        </button>
                        <button type="button" onclick="window.print();" class="btn btn-sm btn-secondary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('inventory.reports.stock-value') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="warehouse_id">المخزن</label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                        <option value="">كل المخازن</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ $selectedWarehouse && $selectedWarehouse->id == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="category_id">التصنيف</label>
                                    <select name="category_id" id="category_id" class="form-control select2">
                                        <option value="">كل التصنيفات</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" {{ $selectedCategory && $selectedCategory->id == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> عرض التقرير
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <h5>معلومات التقرير</h5>
                                            <p><strong>المخزن:</strong> {{ $selectedWarehouse ? $selectedWarehouse->name : 'كل المخازن' }}</p>
                                            <p><strong>التصنيف:</strong> {{ $selectedCategory ? $selectedCategory->name : 'كل التصنيفات' }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h5>ملخص المخزون</h5>
                                            <p><strong>عدد الأصناف:</strong> {{ $totalItems }}</p>
                                            <p><strong>إجمالي القيمة:</strong> {{ number_format($totalValue, 2) }} ريال</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h5>التاريخ</h5>
                                            <p><strong>تاريخ التقرير:</strong> {{ date('Y-m-d') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>#</th>
                                            <th>الصنف</th>
                                            <th>الرمز</th>
                                            <th>التصنيف</th>
                                            <th>الوحدة</th>
                                            <th>سعر الشراء</th>
                                            <th>الكمية</th>
                                            <th>القيمة</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($items as $index => $item)
                                            @php
                                                $quantity = 0;
                                                $value = 0;
                                                
                                                if ($selectedWarehouse) {
                                                    $stock = $item->stocks->where('warehouse_id', $selectedWarehouse->id)->first();
                                                    if ($stock) {
                                                        $quantity = $stock->quantity;
                                                        $value = $quantity * $item->purchase_price;
                                                    }
                                                } else {
                                                    $quantity = $item->total_quantity;
                                                    $value = $item->total_stock_value;
                                                }
                                            @endphp
                                            
                                            @if($quantity > 0)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $item->name }}</td>
                                                    <td>{{ $item->code ?? $item->sku }}</td>
                                                    <td>{{ $item->category ? $item->category->name : '-' }}</td>
                                                    <td>{{ $item->unit }}</td>
                                                    <td>{{ number_format($item->purchase_price, 2) }}</td>
                                                    <td>{{ number_format($quantity, 2) }}</td>
                                                    <td>{{ number_format($value, 2) }}</td>
                                                </tr>
                                            @endif
                                        @empty
                                            <tr>
                                                <td colspan="8" class="text-center">لا توجد أصناف في المخزون</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot class="bg-light">
                                        <tr>
                                            <th colspan="6">الإجمالي</th>
                                            <th>{{ $totalItems }} صنف</th>
                                            <th>{{ number_format($totalValue, 2) }} ريال</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع قيمة المخزون حسب التصنيف</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>التصنيف</th>
                                                    <th>عدد الأصناف</th>
                                                    <th>إجمالي القيمة</th>
                                                    <th>النسبة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $categoryTotals = [];
                                                    
                                                    foreach ($items as $item) {
                                                        $categoryName = $item->category ? $item->category->name : 'بدون تصنيف';
                                                        $itemValue = 0;
                                                        
                                                        if ($selectedWarehouse) {
                                                            $stock = $item->stocks->where('warehouse_id', $selectedWarehouse->id)->first();
                                                            if ($stock && $stock->quantity > 0) {
                                                                $itemValue = $stock->quantity * $item->purchase_price;
                                                            }
                                                        } else {
                                                            $itemValue = $item->total_quantity > 0 ? $item->total_stock_value : 0;
                                                        }
                                                        
                                                        if ($itemValue > 0) {
                                                            if (!isset($categoryTotals[$categoryName])) {
                                                                $categoryTotals[$categoryName] = [
                                                                    'count' => 0,
                                                                    'value' => 0
                                                                ];
                                                            }
                                                            
                                                            $categoryTotals[$categoryName]['count']++;
                                                            $categoryTotals[$categoryName]['value'] += $itemValue;
                                                        }
                                                    }
                                                @endphp
                                                
                                                @forelse($categoryTotals as $categoryName => $data)
                                                    <tr>
                                                        <td>{{ $categoryName }}</td>
                                                        <td>{{ $data['count'] }}</td>
                                                        <td>{{ number_format($data['value'], 2) }}</td>
                                                        <td>{{ $totalValue > 0 ? number_format(($data['value'] / $totalValue) * 100, 1) : 0 }}%</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="4" class="text-center">لا توجد بيانات للعرض</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        .navbar, .main-sidebar, .card-tools, form, footer {
            display: none !important;
        }
        
        .content-wrapper {
            margin-left: 0 !important;
            padding: 0 !important;
        }
        
        .card {
            box-shadow: none !important;
            border: none !important;
        }
        
        .card-header {
            background-color: #f8f9fa !important;
            color: #000 !important;
        }
        
        .table-bordered {
            border: 1px solid #dee2e6 !important;
        }
        
        .table-bordered td, .table-bordered th {
            border: 1px solid #dee2e6 !important;
        }
        
        .badge {
            border: 1px solid #000 !important;
            color: #000 !important;
            background-color: transparent !important;
        }
    }
</style>
@endsection