@extends('layouts.app')

@section('title', 'تقرير حركة المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقرير حركة المخزون</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                        </button>
                        <button type="button" onclick="window.print();" class="btn btn-sm btn-secondary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('inventory.reports.stock-movement') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="warehouse_id">المخزن</label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                        <option value="">كل المخازن</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ $selectedWarehouse && $selectedWarehouse->id == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="item_id">الصنف</label>
                                    <select name="item_id" id="item_id" class="form-control select2">
                                        <option value="">كل الأصناف</option>
                                        @foreach($items as $item)
                                            <option value="{{ $item->id }}" {{ $selectedItem && $selectedItem->id == $item->id ? 'selected' : '' }}>
                                                {{ $item->name }} ({{ $item->code ?? $item->sku }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="date_from">من تاريخ</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ $dateFrom }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="date_to">إلى تاريخ</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ $dateTo }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> عرض التقرير
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <h5>معلومات التقرير</h5>
                                            <p><strong>المخزن:</strong> {{ $selectedWarehouse ? $selectedWarehouse->name : 'كل المخازن' }}</p>
                                            <p><strong>الصنف:</strong> {{ $selectedItem ? $selectedItem->name : 'كل الأصناف' }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h5>معلومات الفترة</h5>
                                            <p><strong>من تاريخ:</strong> {{ $dateFrom }}</p>
                                            <p><strong>إلى تاريخ:</strong> {{ $dateTo }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h5>ملخص الحركة</h5>
                                            <p><strong>عدد الحركات:</strong> {{ count($transactions) }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>التاريخ</th>
                                            <th>الصنف</th>
                                            <th>نوع الحركة</th>
                                            <th>المستند المرجعي</th>
                                            <th>المخزن</th>
                                            <th>المخزن المستلم</th>
                                            <th>الكمية</th>
                                            <th>سعر الوحدة</th>
                                            <th>ملاحظات</th>
                                            <th>المستخدم</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($transactions as $transaction)
                                            <tr>
                                                <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                                <td>{{ $transaction->item->name }}</td>
                                                <td>
                                                    @switch($transaction->transaction_type)
                                                        @case('purchase')
                                                            <span class="badge badge-success">شراء</span>
                                                            @break
                                                        @case('sale')
                                                            <span class="badge badge-danger">بيع</span>
                                                            @break
                                                        @case('transfer')
                                                            <span class="badge badge-info">تحويل</span>
                                                            @break
                                                        @case('adjustment')
                                                            <span class="badge badge-warning">تسوية</span>
                                                            @break
                                                        @case('return_to_supplier')
                                                            <span class="badge badge-secondary">مرتجع لمورد</span>
                                                            @break
                                                        @case('return_from_customer')
                                                            <span class="badge badge-primary">مرتجع من عميل</span>
                                                            @break
                                                        @case('maintenance_usage')
                                                            <span class="badge badge-dark">استخدام صيانة</span>
                                                            @break
                                                        @case('write_off')
                                                            <span class="badge badge-danger">إعدام</span>
                                                            @break
                                                        @default
                                                            <span class="badge badge-secondary">{{ $transaction->transaction_type }}</span>
                                                    @endswitch
                                                </td>
                                                <td>
                                                    @if($transaction->reference_type && $transaction->reference_number)
                                                        @switch($transaction->reference_type)
                                                            @case('purchase_order')
                                                                أمر شراء #{{ $transaction->reference_number }}
                                                                @break
                                                            @case('purchase_invoice')
                                                                فاتورة شراء #{{ $transaction->reference_number }}
                                                                @break
                                                            @case('inventory_adjustment')
                                                                تسوية مخزون #{{ $transaction->reference_number }}
                                                                @break
                                                            @case('inventory_transfer')
                                                                تحويل مخزون #{{ $transaction->reference_number }}
                                                                @break
                                                            @case('inventory_issue')
                                                                إذن صرف #{{ $transaction->reference_number }}
                                                                @break
                                                            @default
                                                                {{ $transaction->reference_type }} #{{ $transaction->reference_number }}
                                                        @endswitch
                                                    @else
                                                        -
                                                    @endif
                                                </td>
                                                <td>{{ $transaction->warehouse ? $transaction->warehouse->name : '-' }}</td>
                                                <td>{{ $transaction->toWarehouse ? $transaction->toWarehouse->name : '-' }}</td>
                                                <td class="{{ $transaction->quantity > 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format(abs($transaction->quantity), 2) }}
                                                </td>
                                                <td>{{ number_format($transaction->unit_price, 2) }}</td>
                                                <td>{{ $transaction->notes ?: '-' }}</td>
                                                <td>{{ $transaction->creator ? $transaction->creator->name : '-' }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="10" class="text-center">لا توجد حركات مخزون خلال الفترة المحددة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    @if(count($transactions) > 0)
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h5>ملخص الحركة حسب النوع</h5>
                                                <div class="table-responsive">
                                                    <table class="table table-sm">
                                                        <tr>
                                                            <th>المشتريات:</th>
                                                            <td>{{ number_format($summary['purchases'], 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>المبيعات:</th>
                                                            <td>{{ number_format($summary['sales'], 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>التحويلات:</th>
                                                            <td>{{ number_format($summary['transfers'], 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>التسويات:</th>
                                                            <td>{{ number_format($summary['adjustments'], 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>المرتجعات:</th>
                                                            <td>{{ number_format($summary['returns'], 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>استخدام الصيانة:</th>
                                                            <td>{{ number_format($summary['maintenance'], 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>الإعدامات:</th>
                                                            <td>{{ number_format($summary['write_offs'], 2) }}</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <button onclick="window.print();" class="btn btn-secondary">
                                <i class="fa fa-print"></i> طباعة التقرير
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
        
        // تحديث قائمة الأصناف عند تغيير المخزن
        $('#warehouse_id').change(function() {
            var warehouseId = $(this).val();
            if (warehouseId) {
                window.location.href = "{{ route('inventory.reports.stock-movement') }}?warehouse_id=" + warehouseId;
            } else {
                window.location.href = "{{ route('inventory.reports.stock-movement') }}";
            }
        });
    });
</script>
@endsection

@section('styles')
<style>
    @media print {
        .card-tools, form, .btn-secondary {
            display: none !important;
        }
        .card {
            box-shadow: none !important;
            border: none !important;
        }
        .card-header {
            background-color: #f8f9fa !important;
            color: #000 !important;
        }
        .table-responsive {
            overflow: visible !important;
        }
    }
</style>
<style>
    @media print {
        .btn, form, .card-header, .no-print {
            display: none !important;
        }
        
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        
        .card-body {
            padding: 0 !important;
        }
        
        body {
            margin: 0;
            padding: 0;
        }
    }
</style>
@endsection