@extends('layouts.app')

@section('title', 'تقرير الأصناف منخفضة المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقرير الأصناف منخفضة المخزون</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                        </button>
                        <button type="button" onclick="window.print();" class="btn btn-sm btn-secondary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('inventory.reports.low-stock') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="warehouse_id">المخزن</label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                        <option value="">كل المخازن</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ $selectedWarehouse && $selectedWarehouse->id == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="category_id">التصنيف</label>
                                    <select name="category_id" id="category_id" class="form-control select2">
                                        <option value="">كل التصنيفات</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" {{ $selectedCategory && $selectedCategory->id == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> عرض التقرير
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <h5>معلومات التقرير</h5>
                                            <p><strong>المخزن:</strong> {{ $selectedWarehouse ? $selectedWarehouse->name : 'كل المخازن' }}</p>
                                            <p><strong>التصنيف:</strong> {{ $selectedCategory ? $selectedCategory->name : 'كل التصنيفات' }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h5>ملخص المخزون</h5>
                                            <p><strong>عدد الأصناف منخفضة المخزون:</strong> {{ count($lowStockItems) }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h5>التاريخ</h5>
                                            <p><strong>تاريخ التقرير:</strong> {{ date('Y-m-d') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i>
                                هذا التقرير يعرض الأصناف التي وصلت كمياتها إلى أو أقل من الحد الأدنى المسموح به في المخزون.
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>#</th>
                                            <th>الصنف</th>
                                            <th>الرمز</th>
                                            <th>التصنيف</th>
                                            <th>الوحدة</th>
                                            <th>المخزن</th>
                                            <th>الكمية الحالية</th>
                                            <th>الحد الأدنى</th>
                                            <th>الحد الأقصى</th>
                                            <th>الكمية المطلوب طلبها</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($lowStockItems as $index => $item)
                                            @php
                                                if ($selectedWarehouse) {
                                                    $stock = $item->stocks->where('warehouse_id', $selectedWarehouse->id)->first();
                                                    $currentQuantity = $stock ? $stock->quantity : 0;
                                                } else {
                                                    $currentQuantity = $item->total_quantity;
                                                }
                                                
                                                $reorderQuantity = max(0, $item->max_stock_level - $currentQuantity);
                                            @endphp
                                            
                                            <tr class="{{ $currentQuantity == 0 ? 'table-danger' : 'table-warning' }}">
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $item->name }}</td>
                                                <td>{{ $item->code ?? $item->sku }}</td>
                                                <td>{{ $item->category ? $item->category->name : '-' }}</td>
                                                <td>{{ $item->unit }}</td>
                                                <td>
                                                    @if($selectedWarehouse)
                                                        {{ $selectedWarehouse->name }}
                                                    @else
                                                        @foreach($item->stocks as $stock)
                                                            @if($stock->quantity <= $item->min_stock_level)
                                                                <span class="badge badge-warning">{{ $stock->warehouse->name }}: {{ $stock->quantity }}</span><br>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                </td>
                                                <td class="text-danger font-weight-bold">{{ number_format($currentQuantity, 2) }}</td>
                                                <td>{{ number_format($item->min_stock_level, 2) }}</td>
                                                <td>{{ number_format($item->max_stock_level, 2) }}</td>
                                                <td class="text-primary font-weight-bold">{{ number_format($reorderQuantity, 2) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="10" class="text-center">لا توجد أصناف منخفضة المخزون</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    @if(count($lowStockItems) > 0)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">ملخص الأصناف منخفضة المخزون حسب التصنيف</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>التصنيف</th>
                                                    <th>عدد الأصناف</th>
                                                    <th>نسبة الأصناف</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $categoryTotals = [];
                                                    $totalItems = count($lowStockItems);
                                                    
                                                    foreach ($lowStockItems as $item) {
                                                        $categoryName = $item->category ? $item->category->name : 'بدون تصنيف';
                                                        
                                                        if (!isset($categoryTotals[$categoryName])) {
                                                            $categoryTotals[$categoryName] = 0;
                                                        }
                                                        
                                                        $categoryTotals[$categoryName]++;
                                                    }
                                                @endphp
                                                
                                                @foreach($categoryTotals as $categoryName => $count)
                                                    <tr>
                                                        <td>{{ $categoryName }}</td>
                                                        <td>{{ $count }}</td>
                                                        <td>{{ number_format(($count / $totalItems) * 100, 1) }}%</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">قائمة الطلب المقترحة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>الصنف</th>
                                                    <th>الرمز</th>
                                                    <th>الوحدة</th>
                                                    <th>الكمية المطلوبة</th>
                                                    <th>سعر الشراء التقديري</th>
                                                    <th>القيمة التقديرية</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $totalEstimatedValue = 0;
                                                @endphp
                                                
                                                @foreach($lowStockItems as $index => $item)
                                                    @php
                                                        if ($selectedWarehouse) {
                                                            $stock = $item->stocks->where('warehouse_id', $selectedWarehouse->id)->first();
                                                            $currentQuantity = $stock ? $stock->quantity : 0;
                                                        } else {
                                                            $currentQuantity = $item->total_quantity;
                                                        }
                                                        
                                                        $reorderQuantity = max(0, $item->max_stock_level - $currentQuantity);
                                                        $estimatedValue = $reorderQuantity * $item->purchase_price;
                                                        $totalEstimatedValue += $estimatedValue;
                                                    @endphp
                                                    
                                                    @if($reorderQuantity > 0)
                                                        <tr>
                                                            <td>{{ $index + 1 }}</td>
                                                            <td>{{ $item->name }}</td>
                                                            <td>{{ $item->code ?? $item->sku }}</td>
                                                            <td>{{ $item->unit }}</td>
                                                            <td>{{ number_format($reorderQuantity, 2) }}</td>
                                                            <td>{{ number_format($item->purchase_price, 2) }}</td>
                                                            <td>{{ number_format($estimatedValue, 2) }}</td>
                                                        </tr>
                                                    @endif
                                                @endforeach
                                                
                                                <tr class="bg-light font-weight-bold">
                                                    <td colspan="6">إجمالي القيمة التقديرية</td>
                                                    <td>{{ number_format($totalEstimatedValue, 2) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        .navbar, .main-sidebar, .card-tools, form, footer {
            display: none !important;
        }
        
        .content-wrapper {
            margin-left: 0 !important;
            padding: 0 !important;
        }
        
        .card {
            box-shadow: none !important;
            border: none !important;
        }
        
        .card-header {
            background-color: #f8f9fa !important;
            color: #000 !important;
        }
        
        .table-bordered {
            border: 1px solid #dee2e6 !important;
        }
        
        .table-bordered td, .table-bordered th {
            border: 1px solid #dee2e6 !important;
        }
        
        .badge {
            border: 1px solid #000 !important;
            color: #000 !important;
            background-color: transparent !important;
        }
        
        .table-danger {
            background-color: #f8d7da !important;
        }
        
        .table-warning {
            background-color: #fff3cd !important;
        }
    }
</style>
@endsection