@extends('layouts.app')

@section('title', 'تقرير حركة صنف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقرير حركة صنف</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                        </button>
                        <button type="button" onclick="window.print();" class="btn btn-sm btn-secondary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('inventory.reports.item-movement') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="warehouse_id">المخزن</label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2">
                                        <option value="">كل المخازن</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ $selectedWarehouse && $selectedWarehouse->id == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="item_id">الصنف</label>
                                    <select name="item_id" id="item_id" class="form-control select2" required>
                                        <option value="">اختر الصنف</option>
                                        @foreach($items as $item)
                                            <option value="{{ $item->id }}" {{ $selectedItem && $selectedItem->id == $item->id ? 'selected' : '' }}>
                                                {{ $item->name }} ({{ $item->code ?? $item->sku }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="date_from">من تاريخ</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ $dateFrom }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="date_to">إلى تاريخ</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ $dateTo }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> عرض التقرير
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($selectedItem)
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <h5>معلومات الصنف</h5>
                                                <p><strong>الاسم:</strong> {{ $selectedItem->name }}</p>
                                                <p><strong>الرمز:</strong> {{ $selectedItem->code ?? $selectedItem->sku }}</p>
                                                <p><strong>الوحدة:</strong> {{ $selectedItem->unit }}</p>
                                            </div>
                                            <div class="col-md-4">
                                                <h5>معلومات المخزن</h5>
                                                <p><strong>المخزن:</strong> {{ $selectedWarehouse ? $selectedWarehouse->name : 'كل المخازن' }}</p>
                                            </div>
                                            <div class="col-md-4">
                                                <h5>معلومات الفترة</h5>
                                                <p><strong>من تاريخ:</strong> {{ $dateFrom }}</p>
                                                <p><strong>إلى تاريخ:</strong> {{ $dateTo }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>التاريخ</th>
                                                <th>نوع الحركة</th>
                                                <th>المستند المرجعي</th>
                                                <th>المخزن</th>
                                                <th>المخزن المستلم</th>
                                                <th>الوارد</th>
                                                <th>المنصرف</th>
                                                <th>الرصيد</th>
                                                <th>ملاحظات</th>
                                                <th>المستخدم</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- رصيد افتتاحي -->
                                            <tr class="table-secondary">
                                                <td colspan="5"><strong>الرصيد الافتتاحي قبل {{ $dateFrom }}</strong></td>
                                                <td></td>
                                                <td></td>
                                                <td><strong>{{ number_format($openingBalance, 2) }}</strong></td>
                                                <td colspan="2"></td>
                                            </tr>
                                            
                                            @forelse($movements as $movement)
                                                <tr>
                                                    <td>{{ $movement['date']->format('Y-m-d H:i') }}</td>
                                                    <td>
                                                        @switch($movement['transaction_type'])
                                                            @case('purchase')
                                                                <span class="badge badge-success">شراء</span>
                                                                @break
                                                            @case('sale')
                                                                <span class="badge badge-danger">بيع</span>
                                                                @break
                                                            @case('transfer')
                                                                <span class="badge badge-info">تحويل</span>
                                                                @break
                                                            @case('adjustment')
                                                                <span class="badge badge-warning">تسوية</span>
                                                                @break
                                                            @case('return_to_supplier')
                                                                <span class="badge badge-secondary">مرتجع لمورد</span>
                                                                @break
                                                            @case('return_from_customer')
                                                                <span class="badge badge-primary">مرتجع من عميل</span>
                                                                @break
                                                            @case('maintenance_usage')
                                                                <span class="badge badge-dark">استخدام صيانة</span>
                                                                @break
                                                            @case('write_off')
                                                                <span class="badge badge-danger">إعدام</span>
                                                                @break
                                                            @default
                                                                <span class="badge badge-secondary">{{ $movement['transaction_type'] }}</span>
                                                        @endswitch
                                                    </td>
                                                    <td>
                                                        @if($movement['reference_type'] && $movement['reference_number'])
                                                            @switch($movement['reference_type'])
                                                                @case('purchase_order')
                                                                    أمر شراء #{{ $movement['reference_number'] }}
                                                                    @break
                                                                @case('purchase_invoice')
                                                                    فاتورة شراء #{{ $movement['reference_number'] }}
                                                                    @break
                                                                @case('inventory_adjustment')
                                                                    تسوية مخزون #{{ $movement['reference_number'] }}
                                                                    @break
                                                                @case('inventory_transfer')
                                                                    تحويل مخزون #{{ $movement['reference_number'] }}
                                                                    @break
                                                                @case('inventory_issue')
                                                                    إذن صرف #{{ $movement['reference_number'] }}
                                                                    @break
                                                                @default
                                                                    {{ $movement['reference_type'] }} #{{ $movement['reference_number'] }}
                                                            @endswitch
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                    <td>{{ $movement['warehouse'] }}</td>
                                                    <td>{{ $movement['to_warehouse'] ?: '-' }}</td>
                                                    <td class="text-success">{{ $movement['in_qty'] > 0 ? number_format($movement['in_qty'], 2) : '' }}</td>
                                                    <td class="text-danger">{{ $movement['out_qty'] > 0 ? number_format($movement['out_qty'], 2) : '' }}</td>
                                                    <td><strong>{{ number_format($movement['balance'], 2) }}</strong></td>
                                                    <td>{{ $movement['notes'] ?: '-' }}</td>
                                                    <td>{{ $movement['created_by'] }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="10" class="text-center">لا توجد حركات للصنف خلال الفترة المحددة</td>
                                                </tr>
                                            @endforelse
                                            
                                            @if(count($movements) > 0)
                                                <!-- رصيد نهائي -->
                                                <tr class="table-primary">
                                                    <td colspan="5"><strong>الرصيد النهائي في {{ $dateTo }}</strong></td>
                                                    <td><strong>{{ number_format($movements->sum('in_qty'), 2) }}</strong></td>
                                                    <td><strong>{{ number_format($movements->sum('out_qty'), 2) }}</strong></td>
                                                    <td><strong>{{ number_format($openingBalance + $movements->sum('in_qty') - $movements->sum('out_qty'), 2) }}</strong></td>
                                                    <td colspan="2"></td>
                                                </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        @if(count($movements) > 0)
                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <div class="card bg-light">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <h5>ملخص الحركة</h5>
                                                    <p><strong>الرصيد الافتتاحي:</strong> {{ number_format($openingBalance, 2) }}</p>
                                                    <p><strong>إجمالي الوارد:</strong> {{ number_format($movements->sum('in_qty'), 2) }}</p>
                                                    <p><strong>إجمالي المنصرف:</strong> {{ number_format($movements->sum('out_qty'), 2) }}</p>
                                                    <p><strong>الرصيد النهائي:</strong> {{ number_format($openingBalance + $movements->sum('in_qty') - $movements->sum('out_qty'), 2) }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button onclick="window.print();" class="btn btn-secondary">
                                    <i class="fa fa-print"></i> طباعة التقرير
                                </button>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> يرجى اختيار صنف لعرض تقرير الحركة
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
        
        // تحديث قائمة الأصناف عند تغيير المخزن
        $('#warehouse_id').change(function() {
            var warehouseId = $(this).val();
            if (warehouseId) {
                window.location.href = "{{ route('inventory.reports.item-movement') }}?warehouse_id=" + warehouseId;
            } else {
                window.location.href = "{{ route('inventory.reports.item-movement') }}";
            }
        });
    });
</script>
@endsection

@section('styles')
<style>
    @media print {
        .card-tools, form, .btn-secondary {
            display: none !important;
        }
        .card {
            box-shadow: none !important;
            border: none !important;
        }
        .card-header {
            background-color: #f8f9fa !important;
            color: #000 !important;
        }
        .table-responsive {
            overflow: visible !important;
        }
    }
</style>
<style>
    @media print {
        .btn, form, .card-header, .no-print {
            display: none !important;
        }
        
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        
        .card-body {
            padding: 0 !important;
        }
        
        body {
            margin: 0;
            padding: 0;
        }
    }
</style>
@endsection