@extends('layouts.app')

@section('title', 'تفاصيل مرتجع المشتريات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل مرتجع المشتريات #{{ $purchaseReturn->return_number }}</h3>
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="{{ route('inventory.purchase-returns.index') }}" class="btn btn-default">
                                <i class="fas fa-arrow-right"></i> العودة للقائمة
                            </a>
                            <a href="{{ route('inventory.purchase-returns.edit', $purchaseReturn->id) }}" class="btn btn-warning">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <a href="{{ route('inventory.purchase-returns.print', $purchaseReturn->id) }}" class="btn btn-secondary" target="_blank">
                                <i class="fas fa-print"></i> طباعة
                            </a>
                            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات المرتجع</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم المرتجع</th>
                                            <td>{{ $purchaseReturn->return_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ المرتجع</th>
                                            <td>{{ $purchaseReturn->return_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المورد</th>
                                            <td>
                                                <a href="{{ route('inventory.suppliers.show', $purchaseReturn->supplier_id) }}">
                                                    {{ $purchaseReturn->supplier->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>
                                                <a href="{{ route('inventory.warehouses.show', $purchaseReturn->warehouse_id) }}">
                                                    {{ $purchaseReturn->warehouse->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>فاتورة المشتريات</th>
                                            <td>
                                                @if($purchaseReturn->purchaseInvoice)
                                                    <a href="{{ route('inventory.purchase-invoices.show', $purchaseReturn->purchaseInvoice->id) }}">
                                                        {{ $purchaseReturn->purchaseInvoice->invoice_number }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير مرتبط</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $purchaseReturn->notes ?: 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المرفق</th>
                                            <td>
                                                @if($purchaseReturn->attachment)
                                                    <a href="{{ asset($purchaseReturn->attachment) }}" target="_blank">
                                                        <i class="fas fa-file"></i> عرض المرفق
                                                    </a>
                                                @else
                                                    <span class="text-muted">لا يوجد مرفق</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">المعلومات المالية</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">المجموع الفرعي</th>
                                            <td>{{ number_format($purchaseReturn->subtotal, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>مبلغ الضريبة</th>
                                            <td>{{ number_format($purchaseReturn->tax_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>مبلغ الخصم</th>
                                            <td>{{ number_format($purchaseReturn->discount_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>الإجمالي</th>
                                            <td><strong>{{ number_format($purchaseReturn->total_amount, 2) }}</strong></td>
                                        </tr>
                                        <tr>
                                            <th>القيد المحاسبي</th>
                                            <td>
                                                @if($purchaseReturn->journalEntry)
                                                    <a href="{{ route('journal-entries.show', $purchaseReturn->journalEntry->id) }}" target="_blank">
                                                        {{ $purchaseReturn->journalEntry->reference_number }}
                                                    </a>
                                                @else
                                                    <span class="text-danger">لم يتم إنشاء قيد محاسبي</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">عناصر المرتجع</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الصنف</th>
                                                    <th>الكمية</th>
                                                    <th>سعر الوحدة</th>
                                                    <th>نسبة الضريبة %</th>
                                                    <th>مبلغ الضريبة</th>
                                                    <th>مبلغ الخصم</th>
                                                    <th>الإجمالي</th>
                                                    <th>ملاحظات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($purchaseReturn->items as $index => $item)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>
                                                            <a href="{{ route('inventory.items.show', $item->inventoryItem->id) }}">
                                                                {{ $item->inventoryItem->name }} - {{ $item->inventoryItem->code }}
                                                            </a>
                                                        </td>
                                                        <td>{{ $item->quantity }}</td>
                                                        <td>{{ number_format($item->unit_price, 2) }}</td>
                                                        <td>{{ $item->tax_rate }}%</td>
                                                        <td>{{ number_format($item->tax_amount, 2) }}</td>
                                                        <td>{{ number_format($item->discount_amount, 2) }}</td>
                                                        <td>{{ number_format($item->total_amount, 2) }}</td>
                                                        <td>{{ $item->notes ?: '-' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="7" class="text-right">الإجمالي</th>
                                                    <th>{{ number_format($purchaseReturn->total_amount, 2) }}</th>
                                                    <th></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Delete Confirmation -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف مرتجع المشتريات رقم <strong>{{ $purchaseReturn->return_number }}</strong>؟
                <p class="text-danger">سيتم حذف جميع البيانات المرتبطة بهذا المرتجع بما في ذلك القيود المحاسبية ومعاملات المخزون.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                <form action="{{ route('inventory.purchase-returns.destroy', $purchaseReturn->id) }}" method="POST" style="display: inline-block;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection