<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>طباعة مرتجع مشتريات #{{ $purchaseReturn->return_number }}</title>
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/bootstrap-rtl.min.css') }}">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            font-size: 14px;
            line-height: 1.5;
            color: #333;
            background-color: #fff;
        }
        .invoice-header {
            border-bottom: 2px solid #ddd;
            padding-bottom: 20px;
            margin-bottom: 20px;
        }
        .invoice-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .company-info {
            margin-bottom: 20px;
        }
        .invoice-details {
            margin-bottom: 20px;
        }
        .table th {
            background-color: #f8f9fa;
        }
        .table-bordered th, .table-bordered td {
            border: 1px solid #ddd;
        }
        .footer {
            margin-top: 30px;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .signature {
            margin-top: 50px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                margin: 0;
                padding: 15px;
            }
            .container {
                width: 100%;
                max-width: 100%;
                padding: 0;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="row no-print mb-3">
            <div class="col-12">
                <button class="btn btn-primary" onclick="window.print()">
                    <i class="fas fa-print"></i> طباعة
                </button>
                <a href="{{ route('inventory.purchase-returns.show', $purchaseReturn->id) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-right"></i> العودة
                </a>
            </div>
        </div>

        <div class="row invoice-header">
            <div class="col-6">
                <div class="invoice-title">مرتجع مشتريات</div>
                <div>رقم المرتجع: {{ $purchaseReturn->return_number }}</div>
                <div>التاريخ: {{ $purchaseReturn->return_date->format('Y-m-d') }}</div>
            </div>
            <div class="col-6 text-left">
                <img src="{{ asset('img/logo.png') }}" alt="شعار الشركة" style="max-height: 80px;">
                <div class="company-info">
                    <div>{{ auth()->user()->company->name ?? 'شركة المصاعد' }}</div>
                    <div>{{ auth()->user()->company->address ?? '' }}</div>
                    <div>هاتف: {{ auth()->user()->company->phone ?? '' }}</div>
                    <div>البريد الإلكتروني: {{ auth()->user()->company->email ?? '' }}</div>
                </div>
            </div>
        </div>

        <div class="row invoice-details">
            <div class="col-6">
                <h5>بيانات المورد</h5>
                <div>الاسم: {{ $purchaseReturn->supplier->name }}</div>
                <div>العنوان: {{ $purchaseReturn->supplier->address }}</div>
                <div>هاتف: {{ $purchaseReturn->supplier->phone }}</div>
                <div>البريد الإلكتروني: {{ $purchaseReturn->supplier->email }}</div>
            </div>
            <div class="col-6">
                <h5>بيانات المرتجع</h5>
                <div>المستودع: {{ $purchaseReturn->warehouse->name }}</div>
                @if($purchaseReturn->purchaseInvoice)
                    <div>فاتورة المشتريات: {{ $purchaseReturn->purchaseInvoice->invoice_number }}</div>
                @endif
                <div>تم الإنشاء بواسطة: {{ $purchaseReturn->creator->name }}</div>
                <div>ملاحظات: {{ $purchaseReturn->notes ?: 'لا توجد ملاحظات' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الصنف</th>
                            <th>الكمية</th>
                            <th>سعر الوحدة</th>
                            <th>نسبة الضريبة %</th>
                            <th>مبلغ الضريبة</th>
                            <th>مبلغ الخصم</th>
                            <th>الإجمالي</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($purchaseReturn->items as $index => $item)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item->inventoryItem->name }} - {{ $item->inventoryItem->code }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>{{ number_format($item->unit_price, 2) }}</td>
                                <td>{{ $item->tax_rate }}%</td>
                                <td>{{ number_format($item->tax_amount, 2) }}</td>
                                <td>{{ number_format($item->discount_amount, 2) }}</td>
                                <td>{{ number_format($item->total_amount, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="7" class="text-right">المجموع الفرعي</th>
                            <th>{{ number_format($purchaseReturn->subtotal, 2) }}</th>
                        </tr>
                        <tr>
                            <th colspan="7" class="text-right">مجموع الضريبة</th>
                            <th>{{ number_format($purchaseReturn->tax_amount, 2) }}</th>
                        </tr>
                        <tr>
                            <th colspan="7" class="text-right">مجموع الخصم</th>
                            <th>{{ number_format($purchaseReturn->discount_amount, 2) }}</th>
                        </tr>
                        <tr>
                            <th colspan="7" class="text-right">الإجمالي النهائي</th>
                            <th>{{ number_format($purchaseReturn->total_amount, 2) }}</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <div class="row footer">
            <div class="col-12">
                <p>تم إنشاء هذا المرتجع بتاريخ {{ $purchaseReturn->created_at->format('Y-m-d H:i') }}</p>
                @if($purchaseReturn->journalEntry)
                    <p>رقم القيد المحاسبي: {{ $purchaseReturn->journalEntry->reference_number }}</p>
                @endif
            </div>
        </div>

        <div class="row signature">
            <div class="col-4 text-center">
                <div>___________________</div>
                <div>توقيع المستلم</div>
            </div>
            <div class="col-4 text-center">
                <div>___________________</div>
                <div>توقيع أمين المستودع</div>
            </div>
            <div class="col-4 text-center">
                <div>___________________</div>
                <div>ختم الشركة</div>
            </div>
        </div>
    </div>
</body>
</html>