@extends('layouts.app')

@section('title', 'مرتجعات المشتريات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة مرتجعات المشتريات</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.purchase-returns.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إنشاء مرتجع جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رقم المرتجع</th>
                                    <th>الشركة</th>
                                    <th>المورد</th>
                                    <th>المستودع</th>
                                    <th>تاريخ المرتجع</th>
                                    <th>إجمالي المبلغ</th>
                                    <th>فاتورة المشتريات</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($purchaseReturns as $index => $return)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $return->return_number }}</td>
                                        <td>{{ $return->company->name }}</td>
                                        <td>{{ $return->supplier->name }}</td>
                                        <td>{{ $return->warehouse->name }}</td>
                                        <td>{{ $return->return_date->format('Y-m-d') }}</td>
                                        <td>{{ number_format($return->total_amount, 2) }}</td>
                                        <td>
                                            @if($return->purchaseInvoice)
                                                <a href="{{ route('inventory.purchase-invoices.show', $return->purchaseInvoice->id) }}">
                                                    {{ $return->purchaseInvoice->invoice_number }}
                                                </a>
                                            @else
                                                <span class="text-muted">غير مرتبط</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('inventory.purchase-returns.show', $return->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> عرض
                                                </a>
                                                <a href="{{ route('inventory.purchase-returns.edit', $return->id) }}" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i> تعديل
                                                </a>
                                                <a href="{{ route('inventory.purchase-returns.print', $return->id) }}" class="btn btn-sm btn-secondary" target="_blank">
                                                    <i class="fas fa-print"></i> طباعة
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $return->id }}">
                                                    <i class="fas fa-trash"></i> حذف
                                                </button>
                                            </div>

                                            <!-- Modal for Delete Confirmation -->
                                            <div class="modal fade" id="deleteModal{{ $return->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف مرتجع المشتريات رقم <strong>{{ $return->return_number }}</strong>؟
                                                            <p class="text-danger">سيتم حذف جميع البيانات المرتبطة بهذا المرتجع بما في ذلك القيود المحاسبية ومعاملات المخزون.</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('inventory.purchase-returns.destroy', $return->id) }}" method="POST" style="display: inline-block;">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد مرتجعات مشتريات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $purchaseReturns->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection