@extends('layouts.modern')

@section('title', 'تفاصيل أمر الشراء')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل أمر الشراء #{{ $purchaseOrder->order_number }}</h3>
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="{{ route('inventory.purchase-orders.index') }}" class="btn btn-default btn-sm">
                                <i class="fas fa-arrow-right"></i> العودة لأوامر الشراء
                            </a>
                            
                            <a href="{{ route('inventory.purchase-orders.print', $purchaseOrder->id) }}" class="btn btn-secondary btn-sm" target="_blank">
                                <i class="fas fa-print"></i> طباعة
                            </a>
                            
                            @if($purchaseOrder->status == 'draft')
                                @can('edit_purchase_orders')
                                <a href="{{ route('inventory.purchase-orders.edit', $purchaseOrder->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit"></i> تعديل
                                </a>
                                @endcan
                            @endif
                            
                            @if($purchaseOrder->status == 'draft' || $purchaseOrder->status == 'pending')
                                @can('approve_purchase_orders')
                                <form action="{{ route('inventory.purchase-orders.approve', $purchaseOrder->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('هل أنت متأكد من الموافقة على أمر الشراء؟')">
                                        <i class="fas fa-check"></i> موافقة
                                    </button>
                                </form>
                                @endcan
                            @endif
                            
                            @if($purchaseOrder->status == 'approved' || $purchaseOrder->status == 'partially_received')
                                @can('receive_purchase_orders')
                                <a href="{{ route('inventory.purchase-orders.receive-form', $purchaseOrder->id) }}" class="btn btn-warning btn-sm">
                                    <i class="fas fa-truck-loading"></i> استلام
                                </a>
                                @endcan
                            @endif
                            
                            @if($purchaseOrder->status != 'received' && $purchaseOrder->status != 'cancelled')
                                @can('cancel_purchase_orders')
                                <form action="{{ route('inventory.purchase-orders.cancel', $purchaseOrder->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من إلغاء أمر الشراء؟')">
                                        <i class="fas fa-times"></i> إلغاء
                                    </button>
                                </form>
                                @endcan
                            @endif
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">معلومات أمر الشراء</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم أمر الشراء</th>
                                            <td>{{ $purchaseOrder->order_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($purchaseOrder->status)
                                                    @case('draft')
                                                        <span class="badge badge-secondary">مسودة</span>
                                                        @break
                                                    @case('pending')
                                                        <span class="badge badge-warning">بانتظار الموافقة</span>
                                                        @break
                                                    @case('approved')
                                                        <span class="badge badge-success">تمت الموافقة</span>
                                                        @break
                                                    @case('received')
                                                        <span class="badge badge-info">تم الاستلام</span>
                                                        @break
                                                    @case('partially_received')
                                                        <span class="badge badge-primary">استلام جزئي</span>
                                                        @break
                                                    @case('cancelled')
                                                        <span class="badge badge-danger">ملغي</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $purchaseOrder->status }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الطلب</th>
                                            <td>{{ $purchaseOrder->order_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التسليم المتوقع</th>
                                            <td>{{ $purchaseOrder->expected_delivery_date ? $purchaseOrder->expected_delivery_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم المرجعي</th>
                                            <td>{{ $purchaseOrder->reference_number ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>{{ $purchaseOrder->warehouse->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $purchaseOrder->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>بواسطة</th>
                                            <td>{{ $purchaseOrder->creator->name ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">معلومات المورد</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم المورد</th>
                                            <td>
                                                <a href="{{ route('inventory.suppliers.show', $purchaseOrder->supplier_id) }}">
                                                    {{ $purchaseOrder->supplier->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td>{{ $purchaseOrder->supplier->phone ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $purchaseOrder->supplier->email ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $purchaseOrder->supplier->address ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم الضريبي</th>
                                            <td>{{ $purchaseOrder->supplier->tax_number ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>جهة الاتصال</th>
                                            <td>{{ $purchaseOrder->supplier->contact_person ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $purchaseOrder->notes ?? 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">عناصر أمر الشراء</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>العنصر</th>
                                                    <th>الكمية</th>
                                                    <th>الكمية المستلمة</th>
                                                    <th>سعر الوحدة</th>
                                                    <th>الخصم</th>
                                                    <th>الضريبة (%)</th>
                                                    <th>الإجمالي</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($purchaseOrder->items as $item)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>
                                                        <a href="{{ route('inventory.items.show', $item->item_id) }}">
                                                            {{ $item->item->name }}
                                                        </a>
                                                        <br>
                                                        <small class="text-muted">{{ $item->item->sku }}</small>
                                                    </td>
                                                    <td>{{ number_format($item->quantity, 2) }}</td>
                                                    <td>{{ number_format($item->received_quantity, 2) }}</td>
                                                    <td>{{ number_format($item->unit_price, 2) }}</td>
                                                    <td>{{ number_format($item->discount, 2) }}</td>
                                                    <td>{{ number_format($item->tax_rate, 2) }}%</td>
                                                    <td>{{ number_format($item->total, 2) }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="7" class="text-left">المجموع الفرعي</th>
                                                    <th>{{ number_format($purchaseOrder->subtotal, 2) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="7" class="text-left">إجمالي الخصم</th>
                                                    <th>{{ number_format($purchaseOrder->total_discount, 2) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="7" class="text-left">إجمالي الضريبة</th>
                                                    <th>{{ number_format($purchaseOrder->total_tax, 2) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="7" class="text-left">الإجمالي النهائي</th>
                                                    <th>{{ number_format($purchaseOrder->total_amount, 2) }}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($purchaseOrder->receivings->count() > 0)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">عمليات الاستلام</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>تاريخ الاستلام</th>
                                                    <th>رقم الاستلام</th>
                                                    <th>العناصر المستلمة</th>
                                                    <th>المستلم</th>
                                                    <th>ملاحظات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($purchaseOrder->receivings as $receiving)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $receiving->receiving_date->format('Y-m-d') }}</td>
                                                    <td>{{ $receiving->receiving_number }}</td>
                                                    <td>{{ $receiving->items_count }}</td>
                                                    <td>{{ $receiving->receiver->name ?? 'غير محدد' }}</td>
                                                    <td>{{ $receiving->notes ?? 'لا توجد ملاحظات' }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.purchase-orders.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة لأوامر الشراء
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection