@extends('layouts.modern')

@section('title', 'استلام أمر الشراء')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">استلام أمر الشراء #{{ $purchaseOrder->order_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.purchase-orders.show', $purchaseOrder->id) }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة لتفاصيل أمر الشراء
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">معلومات أمر الشراء</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم أمر الشراء</th>
                                            <td>{{ $purchaseOrder->order_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>المورد</th>
                                            <td>{{ $purchaseOrder->supplier->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الطلب</th>
                                            <td>{{ $purchaseOrder->order_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>{{ $purchaseOrder->warehouse->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($purchaseOrder->status)
                                                    @case('approved')
                                                        <span class="badge badge-success">تمت الموافقة</span>
                                                        @break
                                                    @case('partially_received')
                                                        <span class="badge badge-primary">استلام جزئي</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $purchaseOrder->status }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">معلومات الاستلام</h3>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('inventory.purchase-orders.receive', $purchaseOrder->id) }}" method="POST" id="receive-form">
                                        @csrf
                                        
                                        <div class="form-group">
                                            <label for="receiving_date">تاريخ الاستلام <span class="text-danger">*</span></label>
                                            <input type="date" name="receiving_date" id="receiving_date" class="form-control @error('receiving_date') is-invalid @enderror" value="{{ old('receiving_date', date('Y-m-d')) }}" required>
                                            @error('receiving_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="reference_number">رقم الفاتورة / المرجع</label>
                                            <input type="text" name="reference_number" id="reference_number" class="form-control @error('reference_number') is-invalid @enderror" value="{{ old('reference_number') }}">
                                            @error('reference_number')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="notes">ملاحظات</label>
                                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                            @error('notes')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header bg-success">
                                        <h3 class="card-title">عناصر أمر الشراء</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>العنصر</th>
                                                        <th>الكمية المطلوبة</th>
                                                        <th>الكمية المستلمة سابقاً</th>
                                                        <th>الكمية المتبقية</th>
                                                        <th>الكمية المستلمة الآن</th>
                                                        <th>رقم الدفعة</th>
                                                        <th>تاريخ الانتهاء</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($purchaseOrder->items as $item)
                                                    <tr>
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td>
                                                            {{ $item->item->name }}
                                                            <br>
                                                            <small class="text-muted">{{ $item->item->sku }}</small>
                                                            <input type="hidden" name="items[{{ $item->id }}][item_id]" value="{{ $item->item_id }}">
                                                        </td>
                                                        <td>{{ number_format($item->quantity, 2) }}</td>
                                                        <td>{{ number_format($item->received_quantity, 2) }}</td>
                                                        <td>{{ number_format($item->quantity - $item->received_quantity, 2) }}</td>
                                                        <td>
                                                            <input type="number" name="items[{{ $item->id }}][received_quantity]" class="form-control received-quantity" value="{{ old('items.' . $item->id . '.received_quantity', min($item->quantity - $item->received_quantity, $item->quantity - $item->received_quantity)) }}" min="0" max="{{ $item->quantity - $item->received_quantity }}" step="0.01" required {{ $item->quantity <= $item->received_quantity ? 'disabled' : '' }}>
                                                        </td>
                                                        <td>
                                                            <input type="text" name="items[{{ $item->id }}][batch_number]" class="form-control" value="{{ old('items.' . $item->id . '.batch_number') }}" {{ $item->quantity <= $item->received_quantity ? 'disabled' : '' }}>
                                                        </td>
                                                        <td>
                                                            <input type="date" name="items[{{ $item->id }}][expiry_date]" class="form-control" value="{{ old('items.' . $item->id . '.expiry_date') }}" {{ $item->quantity <= $item->received_quantity ? 'disabled' : '' }}>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary" form="receive-form">
                                    <i class="fas fa-save"></i> تأكيد الاستلام
                                </button>
                                <a href="{{ route('inventory.purchase-orders.show', $purchaseOrder->id) }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        // التحقق من النموذج قبل الإرسال
        $('#receive-form').submit(function(e) {
            let hasItems = false;
            
            $('.received-quantity').each(function() {
                if (!$(this).prop('disabled') && parseFloat($(this).val()) > 0) {
                    hasItems = true;
                    return false;
                }
            });
            
            if (!hasItems) {
                e.preventDefault();
                alert('يجب استلام كمية واحدة على الأقل من أحد العناصر');
                return false;
            }
            
            return true;
        });
    });
</script>
@endsection