<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>أمر شراء #{{ $purchaseOrder->order_number }}</title>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        body {
            font-family: 'XB Riyaz', 'Traditional Arabic', Arial, sans-serif;
            margin: 0;
            padding: 0;
            direction: rtl;
            font-size: 14px;
            line-height: 1.5;
        }
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .info-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .info-box {
            width: 48%;
            border: 1px solid #ddd;
            padding: 10px;
            border-radius: 5px;
        }
        .info-box h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
            color: #333;
        }
        .info-row {
            display: flex;
            margin-bottom: 5px;
        }
        .info-label {
            font-weight: bold;
            width: 40%;
        }
        .info-value {
            width: 60%;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .total-section {
            margin-top: 20px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .total-row {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 5px;
        }
        .total-label {
            font-weight: bold;
            width: 200px;
            text-align: left;
        }
        .total-value {
            width: 150px;
            text-align: left;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
        }
        .signature-box {
            width: 45%;
            text-align: center;
        }
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 50px;
            padding-top: 5px;
        }
        @media print {
            body {
                font-size: 12px;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>أمر شراء</h1>
            <p>{{ $company->name ?? 'شركة المصاعد' }}</p>
            <p>{{ $company->address ?? '' }}</p>
            <p>هاتف: {{ $company->phone ?? '' }} | بريد إلكتروني: {{ $company->email ?? '' }}</p>
        </div>
        
        <div class="info-section">
            <div class="info-box">
                <h3>معلومات أمر الشراء</h3>
                <div class="info-row">
                    <div class="info-label">رقم أمر الشراء:</div>
                    <div class="info-value">{{ $purchaseOrder->order_number }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">تاريخ الطلب:</div>
                    <div class="info-value">{{ $purchaseOrder->order_date->format('Y-m-d') }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">تاريخ التسليم المتوقع:</div>
                    <div class="info-value">{{ $purchaseOrder->expected_delivery_date ? $purchaseOrder->expected_delivery_date->format('Y-m-d') : 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">الرقم المرجعي:</div>
                    <div class="info-value">{{ $purchaseOrder->reference_number ?? 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">المستودع:</div>
                    <div class="info-value">{{ $purchaseOrder->warehouse->name ?? 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">الحالة:</div>
                    <div class="info-value">
                        @switch($purchaseOrder->status)
                            @case('draft')
                                مسودة
                                @break
                            @case('pending')
                                بانتظار الموافقة
                                @break
                            @case('approved')
                                تمت الموافقة
                                @break
                            @case('received')
                                تم الاستلام
                                @break
                            @case('partially_received')
                                استلام جزئي
                                @break
                            @case('cancelled')
                                ملغي
                                @break
                            @default
                                {{ $purchaseOrder->status }}
                        @endswitch
                    </div>
                </div>
            </div>
            
            <div class="info-box">
                <h3>معلومات المورد</h3>
                <div class="info-row">
                    <div class="info-label">اسم المورد:</div>
                    <div class="info-value">{{ $purchaseOrder->supplier->name }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">رقم الهاتف:</div>
                    <div class="info-value">{{ $purchaseOrder->supplier->phone ?? 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">البريد الإلكتروني:</div>
                    <div class="info-value">{{ $purchaseOrder->supplier->email ?? 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">العنوان:</div>
                    <div class="info-value">{{ $purchaseOrder->supplier->address ?? 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">الرقم الضريبي:</div>
                    <div class="info-value">{{ $purchaseOrder->supplier->tax_number ?? 'غير محدد' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">جهة الاتصال:</div>
                    <div class="info-value">{{ $purchaseOrder->supplier->contact_person ?? 'غير محدد' }}</div>
                </div>
            </div>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>العنصر</th>
                    <th>الكمية</th>
                    <th>سعر الوحدة</th>
                    <th>الخصم</th>
                    <th>الضريبة (%)</th>
                    <th>الإجمالي</th>
                </tr>
            </thead>
            <tbody>
                @foreach($purchaseOrder->items as $item)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>
                        {{ $item->item->name }}
                        <br>
                        <small>{{ $item->item->sku }}</small>
                    </td>
                    <td>{{ number_format($item->quantity, 2) }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ number_format($item->discount, 2) }}</td>
                    <td>{{ number_format($item->tax_rate, 2) }}%</td>
                    <td>{{ number_format($item->total, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        
        <div class="total-section">
            <div class="total-row">
                <div class="total-label">المجموع الفرعي:</div>
                <div class="total-value">{{ number_format($purchaseOrder->subtotal, 2) }}</div>
            </div>
            <div class="total-row">
                <div class="total-label">إجمالي الخصم:</div>
                <div class="total-value">{{ number_format($purchaseOrder->total_discount, 2) }}</div>
            </div>
            <div class="total-row">
                <div class="total-label">إجمالي الضريبة:</div>
                <div class="total-value">{{ number_format($purchaseOrder->total_tax, 2) }}</div>
            </div>
            <div class="total-row">
                <div class="total-label">الإجمالي النهائي:</div>
                <div class="total-value">{{ number_format($purchaseOrder->total_amount, 2) }}</div>
            </div>
        </div>
        
        @if($purchaseOrder->notes)
        <div style="margin-top: 20px; border: 1px solid #ddd; padding: 10px; border-radius: 5px;">
            <h3 style="margin-top: 0;">ملاحظات</h3>
            <p>{{ $purchaseOrder->notes }}</p>
        </div>
        @endif
        
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">توقيع المورد</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">توقيع المستلم</div>
            </div>
        </div>
        
        <div class="footer">
            <p>تم إنشاء هذا المستند بواسطة نظام إدارة المصاعد</p>
            <p>تاريخ الطباعة: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
        
        <div class="no-print" style="margin-top: 20px; text-align: center;">
            <button onclick="window.print()" style="padding: 10px 20px; background-color: #4CAF50; color: white; border: none; border-radius: 5px; cursor: pointer;">
                طباعة
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background-color: #f44336; color: white; border: none; border-radius: 5px; cursor: pointer; margin-right: 10px;">
                إغلاق
            </button>
        </div>
    </div>
</body>
</html>