@extends('layouts.modern')

@section('title', 'أوامر الشراء')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">أوامر الشراء</h3>
                    <div class="card-tools">
                        @can('create_purchase_orders')
                        <a href="{{ route('inventory.purchase-orders.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إنشاء أمر شراء جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('inventory.purchase-orders.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="supplier_id" class="mx-1">المورد:</label>
                                    <select name="supplier_id" id="supplier_id" class="form-control select2">
                                        <option value="">جميع الموردين</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="status" class="mx-1">الحالة:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">جميع الحالات</option>
                                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>بانتظار الموافقة</option>
                                        <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>تمت الموافقة</option>
                                        <option value="received" {{ request('status') == 'received' ? 'selected' : '' }}>تم الاستلام</option>
                                        <option value="partially_received" {{ request('status') == 'partially_received' ? 'selected' : '' }}>استلام جزئي</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="date_from" class="mx-1">من تاريخ:</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="date_to" class="mx-1">إلى تاريخ:</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                                
                                <div class="form-group mx-1">
                                    <label for="search" class="mx-1">بحث:</label>
                                    <input type="text" name="search" id="search" class="form-control" value="{{ request('search') }}" placeholder="رقم أمر الشراء">
                                </div>
                                
                                <button type="submit" class="btn btn-primary mx-1">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                
                                <a href="{{ route('inventory.purchase-orders.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رقم أمر الشراء</th>
                                    <th>المورد</th>
                                    <th>التاريخ</th>
                                    <th>تاريخ التسليم المتوقع</th>
                                    <th>إجمالي العناصر</th>
                                    <th>إجمالي المبلغ</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($purchaseOrders as $order)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $order->order_number }}</td>
                                    <td>{{ $order->supplier->name ?? 'غير محدد' }}</td>
                                    <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                    <td>{{ $order->expected_delivery_date ? $order->expected_delivery_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>{{ $order->items_count }}</td>
                                    <td>{{ number_format($order->total_amount, 2) }}</td>
                                    <td>
                                        @switch($order->status)
                                            @case('draft')
                                                <span class="badge badge-secondary">مسودة</span>
                                                @break
                                            @case('pending')
                                                <span class="badge badge-warning">بانتظار الموافقة</span>
                                                @break
                                            @case('approved')
                                                <span class="badge badge-success">تمت الموافقة</span>
                                                @break
                                            @case('received')
                                                <span class="badge badge-info">تم الاستلام</span>
                                                @break
                                            @case('partially_received')
                                                <span class="badge badge-primary">استلام جزئي</span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary">{{ $order->status }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('inventory.purchase-orders.show', $order->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i> عرض
                                            </a>
                                            
                                            @if($order->status == 'draft')
                                                @can('edit_purchase_orders')
                                                <a href="{{ route('inventory.purchase-orders.edit', $order->id) }}" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-edit"></i> تعديل
                                                </a>
                                                @endcan
                                            @endif
                                            
                                            @if($order->status == 'draft' || $order->status == 'pending')
                                                @can('approve_purchase_orders')
                                                <form action="{{ route('inventory.purchase-orders.approve', $order->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('هل أنت متأكد من الموافقة على أمر الشراء؟')">
                                                        <i class="fas fa-check"></i> موافقة
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif
                                            
                                            @if($order->status == 'approved' || $order->status == 'partially_received')
                                                @can('receive_purchase_orders')
                                                <a href="{{ route('inventory.purchase-orders.receive-form', $order->id) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-truck-loading"></i> استلام
                                                </a>
                                                @endcan
                                            @endif
                                            
                                            @if($order->status != 'received' && $order->status != 'cancelled')
                                                @can('cancel_purchase_orders')
                                                <form action="{{ route('inventory.purchase-orders.cancel', $order->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من إلغاء أمر الشراء؟')">
                                                        <i class="fas fa-times"></i> إلغاء
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif
                                            
                                            <a href="{{ route('inventory.purchase-orders.print', $order->id) }}" class="btn btn-secondary btn-sm" target="_blank">
                                                <i class="fas fa-print"></i> طباعة
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد بيانات متاحة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $purchaseOrders->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        $('.select2').select2();
    });
</script>
@endsection