@extends('layouts.modern')

@section('title', 'إنشاء أمر شراء جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إنشاء أمر شراء جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.purchase-orders.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة لأوامر الشراء
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('inventory.purchase-orders.store') }}" method="POST" id="purchase-order-form">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="supplier_id">المورد <span class="text-danger">*</span></label>
                                    <select name="supplier_id" id="supplier_id" class="form-control select2 @error('supplier_id') is-invalid @enderror" required>
                                        <option value="">اختر المورد</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('supplier_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="warehouse_id">المستودع <span class="text-danger">*</span></label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2 @error('warehouse_id') is-invalid @enderror" required>
                                        <option value="">اختر المستودع</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="order_date">تاريخ الطلب <span class="text-danger">*</span></label>
                                    <input type="date" name="order_date" id="order_date" class="form-control @error('order_date') is-invalid @enderror" value="{{ old('order_date', date('Y-m-d')) }}" required>
                                    @error('order_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="expected_delivery_date">تاريخ التسليم المتوقع</label>
                                    <input type="date" name="expected_delivery_date" id="expected_delivery_date" class="form-control @error('expected_delivery_date') is-invalid @enderror" value="{{ old('expected_delivery_date') }}">
                                    @error('expected_delivery_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reference_number">الرقم المرجعي</label>
                                    <input type="text" name="reference_number" id="reference_number" class="form-control @error('reference_number') is-invalid @enderror" value="{{ old('reference_number') }}">
                                    @error('reference_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="status">الحالة <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                        <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>بانتظار الموافقة</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <h4>عناصر أمر الشراء</h4>
                        
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <button type="button" class="btn btn-success" id="add-item-btn">
                                    <i class="fas fa-plus"></i> إضافة عنصر
                                </button>
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="items-table">
                                <thead>
                                    <tr>
                                        <th>العنصر</th>
                                        <th>الكمية</th>
                                        <th>سعر الوحدة</th>
                                        <th>الخصم</th>
                                        <th>الضريبة (%)</th>
                                        <th>الإجمالي</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody id="items-container">
                                    <!-- سيتم إضافة العناصر هنا بواسطة JavaScript -->
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-left">المجموع الفرعي</th>
                                        <th colspan="2">
                                            <span id="subtotal">0.00</span>
                                            <input type="hidden" name="subtotal" id="subtotal-input" value="0">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th colspan="5" class="text-left">إجمالي الخصم</th>
                                        <th colspan="2">
                                            <span id="total-discount">0.00</span>
                                            <input type="hidden" name="total_discount" id="total-discount-input" value="0">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th colspan="5" class="text-left">إجمالي الضريبة</th>
                                        <th colspan="2">
                                            <span id="total-tax">0.00</span>
                                            <input type="hidden" name="total_tax" id="total-tax-input" value="0">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th colspan="5" class="text-left">الإجمالي النهائي</th>
                                        <th colspan="2">
                                            <span id="grand-total">0.00</span>
                                            <input type="hidden" name="total_amount" id="total-amount-input" value="0">
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ أمر الشراء
                                </button>
                                <a href="{{ route('inventory.purchase-orders.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- قالب صف العنصر -->
<template id="item-row-template">
    <tr class="item-row">
        <td>
            <select name="items[INDEX][item_id]" class="form-control select2 item-select" required>
                <option value="">اختر العنصر</option>
                @foreach($items as $item)
                    <option value="{{ $item->id }}" data-price="{{ $item->purchase_price }}">
                        {{ $item->name }} ({{ $item->sku }})
                    </option>
                @endforeach
            </select>
        </td>
        <td>
            <input type="number" name="items[INDEX][quantity]" class="form-control item-quantity" value="1" min="0.01" step="0.01" required>
        </td>
        <td>
            <input type="number" name="items[INDEX][unit_price]" class="form-control item-price" value="0" min="0" step="0.01" required>
        </td>
        <td>
            <input type="number" name="items[INDEX][discount]" class="form-control item-discount" value="0" min="0" step="0.01">
        </td>
        <td>
            <input type="number" name="items[INDEX][tax_rate]" class="form-control item-tax" value="15" min="0" max="100" step="0.01">
        </td>
        <td>
            <span class="item-total">0.00</span>
            <input type="hidden" name="items[INDEX][total]" class="item-total-input" value="0">
        </td>
        <td>
            <button type="button" class="btn btn-danger btn-sm remove-item-btn">
                <i class="fas fa-trash"></i>
            </button>
        </td>
    </tr>
</template>
@endsection

@section('scripts')
<script>
    $(function () {
        $('.select2').select2();
        
        let itemIndex = 0;
        
        // إضافة عنصر جديد
        $('#add-item-btn').click(function() {
            addItemRow();
        });
        
        // إضافة صف عنصر جديد
        function addItemRow() {
            let template = $('#item-row-template').html();
            template = template.replace(/INDEX/g, itemIndex);
            
            $('#items-container').append(template);
            
            // تهيئة السيليكت2 للعنصر الجديد
            $('.item-select').last().select2();
            
            // ربط الأحداث
            bindItemEvents();
            
            itemIndex++;
        }
        
        // ربط أحداث العناصر
        function bindItemEvents() {
            // عند تغيير العنصر
            $('.item-select').last().change(function() {
                let price = $(this).find(':selected').data('price') || 0;
                $(this).closest('tr').find('.item-price').val(price);
                calculateItemTotal($(this).closest('tr'));
            });
            
            // عند تغيير الكمية أو السعر أو الخصم أو الضريبة
            $('.item-quantity, .item-price, .item-discount, .item-tax').last().on('input', function() {
                calculateItemTotal($(this).closest('tr'));
            });
            
            // حذف العنصر
            $('.remove-item-btn').last().click(function() {
                $(this).closest('tr').remove();
                calculateOrderTotals();
            });
        }
        
        // حساب إجمالي العنصر
        function calculateItemTotal(row) {
            let quantity = parseFloat(row.find('.item-quantity').val()) || 0;
            let price = parseFloat(row.find('.item-price').val()) || 0;
            let discount = parseFloat(row.find('.item-discount').val()) || 0;
            let taxRate = parseFloat(row.find('.item-tax').val()) || 0;
            
            let subtotal = quantity * price;
            let afterDiscount = subtotal - discount;
            let taxAmount = afterDiscount * (taxRate / 100);
            let total = afterDiscount + taxAmount;
            
            row.find('.item-total').text(total.toFixed(2));
            row.find('.item-total-input').val(total);
            
            calculateOrderTotals();
        }
        
        // حساب إجماليات الطلب
        function calculateOrderTotals() {
            let subtotal = 0;
            let totalDiscount = 0;
            let totalTax = 0;
            let grandTotal = 0;
            
            $('.item-row').each(function() {
                let quantity = parseFloat($(this).find('.item-quantity').val()) || 0;
                let price = parseFloat($(this).find('.item-price').val()) || 0;
                let discount = parseFloat($(this).find('.item-discount').val()) || 0;
                let taxRate = parseFloat($(this).find('.item-tax').val()) || 0;
                
                let itemSubtotal = quantity * price;
                let afterDiscount = itemSubtotal - discount;
                let taxAmount = afterDiscount * (taxRate / 100);
                
                subtotal += itemSubtotal;
                totalDiscount += discount;
                totalTax += taxAmount;
            });
            
            grandTotal = subtotal - totalDiscount + totalTax;
            
            $('#subtotal').text(subtotal.toFixed(2));
            $('#subtotal-input').val(subtotal);
            
            $('#total-discount').text(totalDiscount.toFixed(2));
            $('#total-discount-input').val(totalDiscount);
            
            $('#total-tax').text(totalTax.toFixed(2));
            $('#total-tax-input').val(totalTax);
            
            $('#grand-total').text(grandTotal.toFixed(2));
            $('#total-amount-input').val(grandTotal);
        }
        
        // إضافة صف عنصر افتراضي عند تحميل الصفحة
        addItemRow();
        
        // التحقق من النموذج قبل الإرسال
        $('#purchase-order-form').submit(function(e) {
            if ($('.item-row').length === 0) {
                e.preventDefault();
                alert('يجب إضافة عنصر واحد على الأقل لأمر الشراء');
                return false;
            }
            
            return true;
        });
    });
</script>
@endsection