@extends('layouts.app')

@section('title', 'تفاصيل فاتورة المشتريات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل فاتورة المشتريات #{{ $purchaseInvoice->invoice_number }}</h3>
                    
                    <div class="card-tools">
                        <div class="btn-group">
                            @can('edit_purchase_invoices')
                            @if($purchaseInvoice->payment_status != 'paid')
                            <a href="{{ route('inventory.purchase-invoices.edit', $purchaseInvoice) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            @endif
                            @endcan
                            
                            @can('manage_purchase_invoice_payments')
                            @if($purchaseInvoice->payment_status != 'paid')
                            <a href="{{ route('inventory.purchase-invoices.add-payment-form', $purchaseInvoice) }}" class="btn btn-success btn-sm">
                                <i class="fas fa-money-bill-wave"></i> إضافة دفعة
                            </a>
                            @endif
                            @endcan
                            
                            <a href="{{ route('inventory.purchase-invoices.index') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-list"></i> قائمة الفواتير
                            </a>
                            
                            <button class="btn btn-primary btn-sm" onclick="window.print()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الفاتورة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">رقم الفاتورة</th>
                                            <td>{{ $purchaseInvoice->invoice_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم فاتورة المورد</th>
                                            <td>{{ $purchaseInvoice->supplier_invoice_number ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الفاتورة</th>
                                            <td>{{ $purchaseInvoice->invoice_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاستحقاق</th>
                                            <td>{{ $purchaseInvoice->due_date ? $purchaseInvoice->due_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة الدفع</th>
                                            <td>
                                                @if($purchaseInvoice->payment_status == 'unpaid')
                                                    <span class="badge badge-danger">غير مدفوعة</span>
                                                @elseif($purchaseInvoice->payment_status == 'partially_paid')
                                                    <span class="badge badge-warning">مدفوعة جزئياً</span>
                                                @elseif($purchaseInvoice->payment_status == 'paid')
                                                    <span class="badge badge-success">مدفوعة بالكامل</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ المدفوع</th>
                                            <td>{{ number_format($purchaseInvoice->paid_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ المتبقي</th>
                                            <td>{{ number_format($purchaseInvoice->remaining_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>أمر الشراء المرتبط</th>
                                            <td>
                                                @if($purchaseInvoice->purchaseOrder)
                                                    <a href="{{ route('inventory.purchase-orders.show', ['order' => $purchaseInvoice->purchaseOrder->id]) }}">
                                                        {{ $purchaseInvoice->purchaseOrder->order_number }}
                                                    </a>
                                                @else
                                                    غير مرتبط بأمر شراء
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>مرفق الفاتورة</th>
                                            <td>
                                                @if($purchaseInvoice->attachment)
                                                    <a href="{{ asset('storage/' . $purchaseInvoice->attachment) }}" target="_blank" class="btn btn-sm btn-info">
                                                        <i class="fas fa-file"></i> عرض المرفق
                                                    </a>
                                                @else
                                                    لا يوجد مرفق
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات المورد والمستودع</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">المورد</th>
                                            <td>
                                                <a href="{{ route('inventory.suppliers.show', $purchaseInvoice->supplier) }}">
                                                    {{ $purchaseInvoice->supplier->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>رقم هاتف المورد</th>
                                            <td>{{ $purchaseInvoice->supplier->phone ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني للمورد</th>
                                            <td>{{ $purchaseInvoice->supplier->email ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>
                                                <a href="{{ route('inventory.warehouses.show', $purchaseInvoice->warehouse) }}">
                                                    {{ $purchaseInvoice->warehouse->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>موقع المستودع</th>
                                            <td>{{ $purchaseInvoice->warehouse->location ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $purchaseInvoice->creator->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $purchaseInvoice->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $purchaseInvoice->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">عناصر الفاتورة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>العنصر</th>
                                                    <th>الكمية</th>
                                                    <th>سعر الوحدة</th>
                                                    <th>نسبة الضريبة (%)</th>
                                                    <th>قيمة الضريبة</th>
                                                    <th>نسبة الخصم (%)</th>
                                                    <th>قيمة الخصم</th>
                                                    <th>الإجمالي</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($purchaseInvoice->items as $index => $item)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $item->item->name }} ({{ $item->item->sku }})</td>
                                                    <td>{{ $item->quantity }}</td>
                                                    <td>{{ number_format($item->unit_price, 2) }}</td>
                                                    <td>{{ $item->tax_rate }}%</td>
                                                    <td>{{ number_format($item->tax_amount, 2) }}</td>
                                                    <td>{{ $item->discount_rate }}%</td>
                                                    <td>{{ number_format($item->discount_amount, 2) }}</td>
                                                    <td>{{ number_format($item->total_price, 2) }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="8" class="text-right">المجموع الفرعي</th>
                                                    <td>{{ number_format($purchaseInvoice->subtotal, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th colspan="8" class="text-right">إجمالي الضريبة</th>
                                                    <td>{{ number_format($purchaseInvoice->tax_amount, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th colspan="8" class="text-right">إجمالي الخصم</th>
                                                    <td>{{ number_format($purchaseInvoice->discount_amount, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th colspan="8" class="text-right">الإجمالي النهائي</th>
                                                    <td>{{ number_format($purchaseInvoice->total_amount, 2) }}</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">سجل المدفوعات</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>تاريخ الدفع</th>
                                                    <th>المبلغ</th>
                                                    <th>طريقة الدفع</th>
                                                    <th>رقم المرجع</th>
                                                    <th>تم بواسطة</th>
                                                    <th>ملاحظات</th>
                                                    <th>المرفق</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($purchaseInvoice->payments as $index => $payment)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $payment->payment_date->format('Y-m-d') }}</td>
                                                    <td>{{ number_format($payment->amount, 2) }}</td>
                                                    <td>{{ $payment->payment_method }}</td>
                                                    <td>{{ $payment->reference_number ?: 'غير محدد' }}</td>
                                                    <td>{{ $payment->creator->name }}</td>
                                                    <td>{{ $payment->notes ?: 'لا توجد ملاحظات' }}</td>
                                                    <td>
                                                        @if($payment->attachment)
                                                            <a href="{{ asset('storage/' . $payment->attachment) }}" target="_blank" class="btn btn-sm btn-info">
                                                                <i class="fas fa-file"></i> عرض
                                                            </a>
                                                        @else
                                                            لا يوجد مرفق
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            @can('edit_purchase_invoice_payments')
                                                            <a href="{{ route('inventory.purchase-invoice-payments.edit', $payment) }}" class="btn btn-warning btn-sm">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            @endcan
                                                            
                                                            @can('delete_purchase_invoice_payments')
                                                            <form action="{{ route('inventory.purchase-invoice-payments.destroy', $payment) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه الدفعة؟')">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger btn-sm">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </form>
                                                            @endcan
                                                        </div>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="9" class="text-center">لا توجد مدفوعات مسجلة</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($purchaseInvoice->notes)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    {{ $purchaseInvoice->notes }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection