@extends('layouts.app')

@section('title', 'فواتير المشتريات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">فواتير المشتريات</h3>
                    
                    <div class="card-tools">
                        @can('create_purchase_invoices')
                        <a href="{{ route('inventory.purchase-invoices.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إنشاء فاتورة جديدة
                        </a>
                        @endcan
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رقم الفاتورة</th>
                                    <th>المورد</th>
                                    <th>المستودع</th>
                                    <th>تاريخ الفاتورة</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>حالة الدفع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoices as $invoice)
                                <tr>
                                    <td>{{ $invoice->id }}</td>
                                    <td>{{ $invoice->invoice_number }}</td>
                                    <td>{{ $invoice->supplier->name }}</td>
                                    <td>{{ $invoice->warehouse->name }}</td>
                                    <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                    <td>{{ $invoice->due_date ? $invoice->due_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                    <td>
                                        @if($invoice->payment_status == 'unpaid')
                                            <span class="badge badge-danger">غير مدفوعة</span>
                                        @elseif($invoice->payment_status == 'partially_paid')
                                            <span class="badge badge-warning">مدفوعة جزئياً</span>
                                        @elseif($invoice->payment_status == 'paid')
                                            <span class="badge badge-success">مدفوعة بالكامل</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            @can('view_purchase_invoices')
                                            <a href="{{ route('inventory.purchase-invoices.show', $invoice) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('edit_purchase_invoices')
                                            @if($invoice->payment_status != 'paid')
                                            <a href="{{ route('inventory.purchase-invoices.edit', $invoice) }}" class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endif
                                            @endcan
                                            
                                            @can('manage_purchase_invoice_payments')
                                            @if($invoice->payment_status != 'paid')
                                            <a href="{{ route('inventory.purchase-invoices.add-payment-form', $invoice) }}" class="btn btn-success btn-sm">
                                                <i class="fas fa-money-bill-wave"></i>
                                            </a>
                                            @endif
                                            @endcan
                                            
                                            @can('delete_purchase_invoices')
                                            @if($invoice->payment_status == 'unpaid')
                                            <form action="{{ route('inventory.purchase-invoices.destroy', $invoice) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد فواتير مشتريات</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $invoices->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection