@extends('layouts.app')

@section('title', 'تعديل فاتورة المشتريات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل فاتورة المشتريات #{{ $purchaseInvoice->invoice_number }}</h3>
                    
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="{{ route('inventory.purchase-invoices.show', $purchaseInvoice) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-eye"></i> عرض التفاصيل
                            </a>
                            <a href="{{ route('inventory.purchase-invoices.index') }}" class="btn btn-info btn-sm">
                                <i class="fas fa-list"></i> قائمة الفواتير
                            </a>
                        </div>
                    </div>
                </div>
                
                <form action="{{ route('inventory.purchase-invoices.update', $purchaseInvoice) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="invoice_number">رقم الفاتورة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('invoice_number') is-invalid @enderror" id="invoice_number" name="invoice_number" value="{{ old('invoice_number', $purchaseInvoice->invoice_number) }}" required>
                                    @error('invoice_number')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="supplier_invoice_number">رقم فاتورة المورد</label>
                                    <input type="text" class="form-control @error('supplier_invoice_number') is-invalid @enderror" id="supplier_invoice_number" name="supplier_invoice_number" value="{{ old('supplier_invoice_number', $purchaseInvoice->supplier_invoice_number) }}">
                                    @error('supplier_invoice_number')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="purchase_order_id">أمر الشراء المرتبط</label>
                                    <select class="form-control select2 @error('purchase_order_id') is-invalid @enderror" id="purchase_order_id" name="purchase_order_id">
                                        <option value="">-- اختر أمر الشراء --</option>
                                        @foreach($purchaseOrders as $order)
                                            <option value="{{ $order->id }}" {{ old('purchase_order_id', $purchaseInvoice->purchase_order_id) == $order->id ? 'selected' : '' }}>
                                                {{ $order->order_number }} - {{ $order->supplier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('purchase_order_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="supplier_id">المورد <span class="text-danger">*</span></label>
                                    <select class="form-control select2 @error('supplier_id') is-invalid @enderror" id="supplier_id" name="supplier_id" required>
                                        <option value="">-- اختر المورد --</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ old('supplier_id', $purchaseInvoice->supplier_id) == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('supplier_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="warehouse_id">المستودع <span class="text-danger">*</span></label>
                                    <select class="form-control select2 @error('warehouse_id') is-invalid @enderror" id="warehouse_id" name="warehouse_id" required>
                                        <option value="">-- اختر المستودع --</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id', $purchaseInvoice->warehouse_id) == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="attachment">مرفق الفاتورة</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                        <label class="custom-file-label" for="attachment">اختر ملف</label>
                                        @error('attachment')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @if($purchaseInvoice->attachment)
                                        <div class="mt-2">
                                            <a href="{{ asset('storage/' . $purchaseInvoice->attachment) }}" target="_blank" class="btn btn-sm btn-info">
                                                <i class="fas fa-file"></i> عرض المرفق الحالي
                                            </a>
                                            <div class="form-check mt-1">
                                                <input type="checkbox" class="form-check-input" id="remove_attachment" name="remove_attachment" value="1">
                                                <label class="form-check-label" for="remove_attachment">إزالة المرفق الحالي</label>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="invoice_date">تاريخ الفاتورة <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('invoice_date') is-invalid @enderror" id="invoice_date" name="invoice_date" value="{{ old('invoice_date', $purchaseInvoice->invoice_date->format('Y-m-d')) }}" required>
                                    @error('invoice_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="due_date">تاريخ الاستحقاق</label>
                                    <input type="date" class="form-control @error('due_date') is-invalid @enderror" id="due_date" name="due_date" value="{{ old('due_date', $purchaseInvoice->due_date ? $purchaseInvoice->due_date->format('Y-m-d') : '') }}">
                                    @error('due_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $purchaseInvoice->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <h4>عناصر الفاتورة</h4>
                        
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead>
                                    <tr>
                                        <th>العنصر</th>
                                        <th>الكمية</th>
                                        <th>سعر الوحدة</th>
                                        <th>نسبة الضريبة (%)</th>
                                        <th>قيمة الضريبة</th>
                                        <th>نسبة الخصم (%)</th>
                                        <th>قيمة الخصم</th>
                                        <th>الإجمالي</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($purchaseInvoice->items as $index => $invoiceItem)
                                    <tr class="item-row">
                                        <td>
                                            <select class="form-control select2 item-select" name="items[{{ $index }}][item_id]" required>
                                                <option value="">-- اختر العنصر --</option>
                                                @foreach($items as $item)
                                                    <option value="{{ $item->id }}" data-price="{{ $item->purchase_price }}" {{ $invoiceItem->item_id == $item->id ? 'selected' : '' }}>
                                                        {{ $item->name }} ({{ $item->sku }})
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $invoiceItem->id }}">
                                            <input type="hidden" name="items[{{ $index }}][purchase_order_item_id]" value="{{ $invoiceItem->purchase_order_item_id }}">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-quantity" name="items[{{ $index }}][quantity]" min="0.01" step="0.01" value="{{ $invoiceItem->quantity }}" required>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-price" name="items[{{ $index }}][unit_price]" min="0" step="0.01" value="{{ $invoiceItem->unit_price }}" required>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-tax-rate" name="items[{{ $index }}][tax_rate]" min="0" step="0.01" value="{{ $invoiceItem->tax_rate }}">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-tax-amount" name="items[{{ $index }}][tax_amount]" min="0" step="0.01" value="{{ $invoiceItem->tax_amount }}" readonly>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-discount-rate" name="items[{{ $index }}][discount_rate]" min="0" step="0.01" value="{{ $invoiceItem->discount_rate }}">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-discount-amount" name="items[{{ $index }}][discount_amount]" min="0" step="0.01" value="{{ $invoiceItem->discount_amount }}" readonly>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-total" name="items[{{ $index }}][total_price]" min="0" step="0.01" value="{{ $invoiceItem->total_price }}" readonly>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-sm remove-item">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="9">
                                            <button type="button" class="btn btn-success btn-sm" id="add-item">
                                                <i class="fas fa-plus"></i> إضافة عنصر
                                            </button>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 offset-md-6">
                                <table class="table table-bordered">
                                    <tr>
                                        <th>المجموع الفرعي</th>
                                        <td>
                                            <input type="number" class="form-control" id="subtotal" name="subtotal" min="0" step="0.01" value="{{ $purchaseInvoice->subtotal }}" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>إجمالي الضريبة</th>
                                        <td>
                                            <input type="number" class="form-control" id="tax_amount" name="tax_amount" min="0" step="0.01" value="{{ $purchaseInvoice->tax_amount }}" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>إجمالي الخصم</th>
                                        <td>
                                            <input type="number" class="form-control" id="discount_amount" name="discount_amount" min="0" step="0.01" value="{{ $purchaseInvoice->discount_amount }}" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>الإجمالي النهائي</th>
                                        <td>
                                            <input type="number" class="form-control" id="total_amount" name="total_amount" min="0" step="0.01" value="{{ $purchaseInvoice->total_amount }}" readonly>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> حفظ التغييرات
                        </button>
                        <a href="{{ route('inventory.purchase-invoices.show', $purchaseInvoice) }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> إلغاء
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(function() {
        // تهيئة السيلكت2
        $('.select2').select2({
            width: '100%',
            dir: 'rtl'
        });
        
        // حساب المبالغ عند تغيير الكمية أو السعر أو نسبة الضريبة أو نسبة الخصم
        $(document).on('change', '.item-quantity, .item-price, .item-tax-rate, .item-discount-rate', function() {
            calculateItemTotal($(this).closest('tr'));
            calculateInvoiceTotal();
        });
        
        // إضافة عنصر جديد
        $('#add-item').click(function() {
            var rowCount = $('.item-row').length;
            var newRow = $('.item-row:first').clone();
            
            // إعادة تعيين القيم
            newRow.find('select, input').each(function() {
                var name = $(this).attr('name');
                if (name) {
                    var newName = name.replace(/\[\d+\]/, '[' + rowCount + ']');
                    $(this).attr('name', newName);
                }
            });
            
            newRow.find('select.item-select').val('').trigger('change');
            newRow.find('input[type="number"]').val(0);
            newRow.find('input.item-quantity').val(1);
            newRow.find('input[type="hidden"]').val('');
            
            // إضافة الصف الجديد
            $('#items-table tbody').append(newRow);
            
            // إعادة تهيئة السيلكت2 للصف الجديد
            newRow.find('.select2').select2({
                width: '100%',
                dir: 'rtl'
            });
        });
        
        // حذف عنصر
        $(document).on('click', '.remove-item', function() {
            if ($('.item-row').length > 1) {
                $(this).closest('tr').remove();
                calculateInvoiceTotal();
            } else {
                alert('يجب أن تحتوي الفاتورة على عنصر واحد على الأقل');
            }
        });
        
        // تحديث سعر العنصر عند اختياره
        $(document).on('change', '.item-select', function() {
            var selectedOption = $(this).find('option:selected');
            var price = selectedOption.data('price') || 0;
            $(this).closest('tr').find('.item-price').val(price);
            calculateItemTotal($(this).closest('tr'));
            calculateInvoiceTotal();
        });
        
        // حساب إجمالي العنصر
        function calculateItemTotal(row) {
            var quantity = parseFloat(row.find('.item-quantity').val()) || 0;
            var price = parseFloat(row.find('.item-price').val()) || 0;
            var taxRate = parseFloat(row.find('.item-tax-rate').val()) || 0;
            var discountRate = parseFloat(row.find('.item-discount-rate').val()) || 0;
            
            var subtotal = quantity * price;
            var discountAmount = (subtotal * discountRate) / 100;
            var afterDiscount = subtotal - discountAmount;
            var taxAmount = (afterDiscount * taxRate) / 100;
            var total = afterDiscount + taxAmount;
            
            row.find('.item-discount-amount').val(discountAmount.toFixed(2));
            row.find('.item-tax-amount').val(taxAmount.toFixed(2));
            row.find('.item-total').val(total.toFixed(2));
        }
        
        // حساب إجمالي الفاتورة
        function calculateInvoiceTotal() {
            var subtotal = 0;
            var taxTotal = 0;
            var discountTotal = 0;
            var grandTotal = 0;
            
            $('.item-row').each(function() {
                subtotal += parseFloat($(this).find('.item-price').val() || 0) * parseFloat($(this).find('.item-quantity').val() || 0);
                taxTotal += parseFloat($(this).find('.item-tax-amount').val() || 0);
                discountTotal += parseFloat($(this).find('.item-discount-amount').val() || 0);
                grandTotal += parseFloat($(this).find('.item-total').val() || 0);
            });
            
            $('#subtotal').val(subtotal.toFixed(2));
            $('#tax_amount').val(taxTotal.toFixed(2));
            $('#discount_amount').val(discountTotal.toFixed(2));
            $('#total_amount').val(grandTotal.toFixed(2));
        }
        
        // حساب الإجماليات عند تحميل الصفحة
        $('.item-row').each(function() {
            calculateItemTotal($(this));
        });
        calculateInvoiceTotal();
    });
</script>
@endpush