@extends('layouts.app')

@section('title', 'إضافة دفعة لفاتورة المشتريات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة دفعة لفاتورة المشتريات #{{ $purchaseInvoice->invoice_number }}</h3>
                </div>
                
                <form action="{{ route('inventory.purchase-invoices.add-payment', $purchaseInvoice) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">معلومات الفاتورة</h5>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th style="width: 40%">رقم الفاتورة</th>
                                                <td>{{ $purchaseInvoice->invoice_number }}</td>
                                            </tr>
                                            <tr>
                                                <th>المورد</th>
                                                <td>{{ $purchaseInvoice->supplier->name }}</td>
                                            </tr>
                                            <tr>
                                                <th>تاريخ الفاتورة</th>
                                                <td>{{ $purchaseInvoice->invoice_date->format('Y-m-d') }}</td>
                                            </tr>
                                            <tr>
                                                <th>تاريخ الاستحقاق</th>
                                                <td>{{ $purchaseInvoice->due_date ? $purchaseInvoice->due_date->format('Y-m-d') : 'غير محدد' }}</td>
                                            </tr>
                                            <tr>
                                                <th>إجمالي الفاتورة</th>
                                                <td>{{ number_format($purchaseInvoice->total_amount, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <th>المبلغ المدفوع</th>
                                                <td>{{ number_format($purchaseInvoice->paid_amount, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <th>المبلغ المتبقي</th>
                                                <td>{{ number_format($purchaseInvoice->remaining_amount, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <th>حالة الدفع</th>
                                                <td>
                                                    @if($purchaseInvoice->payment_status == 'unpaid')
                                                        <span class="badge badge-danger">غير مدفوعة</span>
                                                    @elseif($purchaseInvoice->payment_status == 'partially_paid')
                                                        <span class="badge badge-warning">مدفوعة جزئياً</span>
                                                    @elseif($purchaseInvoice->payment_status == 'paid')
                                                        <span class="badge badge-success">مدفوعة بالكامل</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">تفاصيل الدفعة</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="payment_date">تاريخ الدفع <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control @error('payment_date') is-invalid @enderror" id="payment_date" name="payment_date" value="{{ old('payment_date', date('Y-m-d')) }}" required>
                                            @error('payment_date')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="amount">المبلغ <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" min="0.01" step="0.01" value="{{ old('amount', $purchaseInvoice->remaining_amount) }}" required>
                                            @error('amount')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                            <small class="form-text text-muted">المبلغ المتبقي: {{ number_format($purchaseInvoice->remaining_amount, 2) }}</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="payment_method">طريقة الدفع <span class="text-danger">*</span></label>
                                            <select class="form-control @error('payment_method') is-invalid @enderror" id="payment_method" name="payment_method" required>
                                                <option value="">-- اختر طريقة الدفع --</option>
                                                <option value="cash" {{ old('payment_method') == 'cash' ? 'selected' : '' }}>نقداً</option>
                                                <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                                <option value="check" {{ old('payment_method') == 'check' ? 'selected' : '' }}>شيك</option>
                                                <option value="credit_card" {{ old('payment_method') == 'credit_card' ? 'selected' : '' }}>بطاقة ائتمان</option>
                                                <option value="other" {{ old('payment_method') == 'other' ? 'selected' : '' }}>أخرى</option>
                                            </select>
                                            @error('payment_method')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="reference_number">رقم المرجع</label>
                                            <input type="text" class="form-control @error('reference_number') is-invalid @enderror" id="reference_number" name="reference_number" value="{{ old('reference_number') }}">
                                            @error('reference_number')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                            <small class="form-text text-muted">رقم الشيك أو رقم التحويل البنكي أو أي مرجع آخر</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="attachment">مرفق الدفعة</label>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                                <label class="custom-file-label" for="attachment">اختر ملف</label>
                                                @error('attachment')
                                                    <span class="invalid-feedback">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <small class="form-text text-muted">صورة الشيك أو إيصال التحويل البنكي أو أي إثبات للدفع</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="notes">ملاحظات</label>
                                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                            @error('notes')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ الدفعة</button>
                        <a href="{{ route('inventory.purchase-invoices.show', $purchaseInvoice) }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection