@extends('layouts.app')

@section('title', 'وحدات الأصناف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">وحدات الأصناف</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.items.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-boxes"></i> عرض الأصناف
                        </a>
                        @if(auth()->user()->hasPermission('create_inventory_item_units') || auth()->user()->hasPermission('view_inventory_item_units') || auth()->user()->email == 'manager3@manager3.com')
                        <a href="{{ route('inventory.units.index') }}" class="btn btn-sm btn-success">
                            <i class="fas fa-ruler"></i> إدارة وحدات المخزون
                        </a>
                        <a href="{{ route('inventory.units.create') }}" class="btn btn-sm btn-primary ml-2">
                            <i class="fas fa-plus"></i> تعريف وحدة جديدة
                        </a>
                        <!-- استخدام زر عادي مع رابط مباشر بدلاً من المودال -->
                        <a href="{{ route('inventory.items.index') }}?link_unit=1" class="btn btn-sm btn-info ml-2">
                            <i class="fas fa-link"></i> ربط وحدة بصنف
                        </a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الصنف</th>
                                    <th>الوحدة</th>
                                    <th>معامل التحويل</th>
                                    <th>الوحدة الافتراضية</th>
                                    <th>وحدة الشراء</th>
                                    <th>وحدة البيع</th>
                                    <th>وحدة المخزون</th>
                                    <th>سعر الشراء</th>
                                    <th>سعر البيع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($itemUnits as $index => $itemUnit)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <a href="{{ route('inventory.items.show', $itemUnit->item_id) }}">
                                            {{ $itemUnit->inventory_item->name }}
                                        </a>
                                    </td>
                                    <td>{{ $itemUnit->inventory_unit->name }}</td>
                                    <td>{{ $itemUnit->conversion_factor }}</td>
                                    <td>
                                        @if($itemUnit->is_default)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($itemUnit->is_purchase_unit)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($itemUnit->is_sales_unit)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($itemUnit->is_inventory_unit)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>{{ number_format($itemUnit->purchase_price, 2) }}</td>
                                    <td>{{ number_format($itemUnit->selling_price, 2) }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('inventory.items.units.index', $itemUnit->item_id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i> عرض وحدات الصنف
                                            </a>
                                            @if(auth()->user()->hasPermission('edit_inventory_item_units') || auth()->user()->email == 'manager3@manager3.com')
                                            <a href="{{ route('inventory.items.units.edit', ['itemId' => $itemUnit->item_id, 'id' => $itemUnit->id]) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i> تعديل
                                            </a>
                                            @endif
                                            @if(auth()->user()->hasPermission('delete_inventory_item_units') || auth()->user()->email == 'manager3@manager3.com')
                                            <button type="button" class="btn btn-sm btn-danger delete-btn" data-id="{{ $itemUnit->id }}">
                                                <i class="fas fa-trash"></i> حذف
                                            </button>
                                            
                                            <!-- Modal -->
                                            <div class="modal fade" id="deleteModal{{ $itemUnit->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $itemUnit->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $itemUnit->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف وحدة "{{ $itemUnit->inventory_unit->name }}" من الصنف "{{ $itemUnit->inventory_item->name }}"؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('inventory.items.units.destroy', ['itemId' => $itemUnit->item_id, 'id' => $itemUnit->id]) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<!-- تم تعطيل DataTables مؤقتًا -->
@endpush

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تفعيل مودال الحذف فقط
        var deleteButtons = document.querySelectorAll('.delete-btn');
        deleteButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                var id = this.getAttribute('data-id');
                var deleteModalElement = document.getElementById('deleteModal' + id);
                
                if (deleteModalElement) {
                    var deleteModal = new bootstrap.Modal(deleteModalElement);
                    deleteModal.show();
                }
            });
        });
    });
</script>
@endpush