@extends('layouts.app')

@section('title', 'وحدات الصنف: ' . $item->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">وحدات الصنف: {{ $item->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.items.units.create', $item->id) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة وحدة جديدة
                        </a>
                        <a href="{{ route('inventory.items.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للأصناف
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الوحدة</th>
                                    <th>معامل التحويل</th>
                                    <th>الوحدة الافتراضية</th>
                                    <th>وحدة الشراء</th>
                                    <th>وحدة البيع</th>
                                    <th>وحدة المخزون</th>
                                    <th>سعر الشراء</th>
                                    <th>سعر البيع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($itemUnits as $index => $itemUnit)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $itemUnit->inventory_unit->name }}</td>
                                    <td>{{ $itemUnit->conversion_factor }}</td>
                                    <td>
                                        @if($itemUnit->is_default)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($itemUnit->is_purchase_unit)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($itemUnit->is_sales_unit)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($itemUnit->is_inventory_unit)
                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                        @else
                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                        @endif
                                    </td>
                                    <td>{{ number_format($itemUnit->purchase_price, 2) }}</td>
                                    <td>{{ number_format($itemUnit->selling_price, 2) }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('inventory.items.units.edit', ['itemId' => $item->id, 'id' => $itemUnit->id]) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i> تعديل
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $itemUnit->id }}">
                                                <i class="fas fa-trash"></i> حذف
                                            </button>
                                        </div>
                                        
                                        <!-- Modal -->
                                        <div class="modal fade" id="deleteModal{{ $itemUnit->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $itemUnit->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel{{ $itemUnit->id }}">تأكيد الحذف</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        هل أنت متأكد من حذف وحدة "{{ $itemUnit->inventory_unit->name }}" من الصنف؟
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                        <form action="{{ route('inventory.items.units.destroy', ['itemId' => $item->id, 'id' => $itemUnit->id]) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection