@extends('layouts.app')

@section('title', 'تعديل وحدة الصنف: ' . $item->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل وحدة "{{ $itemUnit->inventory_unit->name }}" للصنف: {{ $item->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.items.units.index', $item->id) }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة لوحدات الصنف
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('inventory.items.units.update', ['itemId' => $item->id, 'id' => $itemUnit->id]) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="form-group">
                            <label>الوحدة</label>
                            <input type="text" class="form-control" value="{{ $itemUnit->inventory_unit->name }}" disabled>
                        </div>
                        
                        <div class="form-group">
                            <label for="conversion_factor">معامل التحويل</label>
                            <input type="number" name="conversion_factor" id="conversion_factor" class="form-control @error('conversion_factor') is-invalid @enderror" value="{{ old('conversion_factor', $itemUnit->conversion_factor) }}" step="0.0001" min="0.0001" required>
                            <small class="form-text text-muted">
                                معامل التحويل هو عدد الوحدات الأساسية التي تعادل وحدة واحدة من هذه الوحدة.
                                <br>
                                مثال: إذا كانت الوحدة الأساسية هي "قطعة" وهذه الوحدة هي "علبة" تحتوي على 12 قطعة، فإن معامل التحويل هو 12.
                            </small>
                            @error('conversion_factor')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_default" id="is_default" class="custom-control-input" {{ old('is_default', $itemUnit->is_default) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_default">الوحدة الافتراضية</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_purchase_unit" id="is_purchase_unit" class="custom-control-input" {{ old('is_purchase_unit', $itemUnit->is_purchase_unit) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_purchase_unit">وحدة الشراء</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_sales_unit" id="is_sales_unit" class="custom-control-input" {{ old('is_sales_unit', $itemUnit->is_sales_unit) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_sales_unit">وحدة البيع</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_inventory_unit" id="is_inventory_unit" class="custom-control-input" {{ old('is_inventory_unit', $itemUnit->is_inventory_unit) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_inventory_unit">وحدة المخزون</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="purchase_price">سعر الشراء</label>
                            <input type="number" name="purchase_price" id="purchase_price" class="form-control @error('purchase_price') is-invalid @enderror" value="{{ old('purchase_price', $itemUnit->purchase_price) }}" step="0.01" min="0">
                            @error('purchase_price')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="selling_price">سعر البيع</label>
                            <input type="number" name="selling_price" id="selling_price" class="form-control @error('selling_price') is-invalid @enderror" value="{{ old('selling_price', $itemUnit->selling_price) }}" step="0.01" min="0">
                            @error('selling_price')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection