@extends('layouts.app')

@section('title', 'إضافة وحدة جديدة للصنف: ' . $item->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة وحدة جديدة للصنف: {{ $item->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.item-units.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة لوحدات الأصناف
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('inventory.items.units.store', $item->id) }}" method="POST">
                        @csrf
                        
                        <div class="form-group">
                            <label for="unit_id">الوحدة</label>
                            <select name="unit_id" id="unit_id" class="form-control @error('unit_id') is-invalid @enderror" required>
                                <option value="">-- اختر الوحدة --</option>
                                @foreach($units as $unit)
                                <option value="{{ $unit->id }}" {{ old('unit_id') == $unit->id ? 'selected' : '' }}>
                                    {{ $unit->name }} {{ $unit->is_base ? '(وحدة أساسية)' : '' }}
                                </option>
                                @endforeach
                            </select>
                            @error('unit_id')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="conversion_factor">معامل التحويل</label>
                            <input type="number" name="conversion_factor" id="conversion_factor" class="form-control @error('conversion_factor') is-invalid @enderror" value="{{ old('conversion_factor', 1) }}" step="0.0001" min="0.0001" required>
                            <small class="form-text text-muted">
                                معامل التحويل هو عدد الوحدات الأساسية التي تعادل وحدة واحدة من هذه الوحدة.
                                <br>
                                مثال: إذا كانت الوحدة الأساسية هي "قطعة" وهذه الوحدة هي "علبة" تحتوي على 12 قطعة، فإن معامل التحويل هو 12.
                            </small>
                            @error('conversion_factor')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_default" id="is_default" class="custom-control-input" {{ old('is_default') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_default">الوحدة الافتراضية</label>
                                <small class="form-text text-muted">
                                    الوحدة الافتراضية هي الوحدة التي سيتم استخدامها افتراضيًا في المعاملات.
                                </small>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_purchase_unit" id="is_purchase_unit" class="custom-control-input" {{ old('is_purchase_unit') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_purchase_unit">وحدة الشراء</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_sales_unit" id="is_sales_unit" class="custom-control-input" {{ old('is_sales_unit') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_sales_unit">وحدة البيع</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="is_inventory_unit" id="is_inventory_unit" class="custom-control-input" {{ old('is_inventory_unit') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_inventory_unit">وحدة المخزون</label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="purchase_price">سعر الشراء</label>
                            <input type="number" name="purchase_price" id="purchase_price" class="form-control @error('purchase_price') is-invalid @enderror" value="{{ old('purchase_price', 0) }}" step="0.01" min="0">
                            @error('purchase_price')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="selling_price">سعر البيع</label>
                            <input type="number" name="selling_price" id="selling_price" class="form-control @error('selling_price') is-invalid @enderror" value="{{ old('selling_price', 0) }}" step="0.01" min="0">
                            @error('selling_price')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection