@extends('layouts.app')

@section('title', 'تفاصيل عنصر المخزون')

@section('styles')
<style>
    .nav-tabs-custom .nav-item .nav-link {
        font-weight: 600;
        color: #495057;
    }
    .nav-tabs-custom .nav-item .nav-link.active {
        color: #007bff;
        border-color: #007bff #dee2e6 #fff;
    }
    .card-header-tabs {
        margin-right: -1.25rem;
        margin-bottom: -0.75rem;
        margin-left: -1.25rem;
        border-bottom: 0;
    }
    .info-box {
        box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
        border-radius: 0.25rem;
        background-color: #fff;
        display: flex;
        margin-bottom: 1rem;
        min-height: 80px;
        padding: 0.5rem;
        position: relative;
        width: 100%;
    }
    .info-box .info-box-icon {
        border-radius: 0.25rem;
        align-items: center;
        display: flex;
        font-size: 1.875rem;
        justify-content: center;
        text-align: center;
        width: 70px;
    }
    .info-box .info-box-content {
        display: flex;
        flex-direction: column;
        justify-content: center;
        line-height: 1.8;
        flex: 1;
        padding: 0 10px;
    }
    .info-box .info-box-text {
        display: block;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .info-box .info-box-number {
        display: block;
        font-weight: 700;
    }
    .bg-info-light {
        background-color: rgba(23, 162, 184, 0.2);
        color: #17a2b8;
    }
    .bg-success-light {
        background-color: rgba(40, 167, 69, 0.2);
        color: #28a745;
    }
    .bg-warning-light {
        background-color: rgba(255, 193, 7, 0.2);
        color: #ffc107;
    }
    .bg-danger-light {
        background-color: rgba(220, 53, 69, 0.2);
        color: #dc3545;
    }
    .action-buttons {
        display: flex;
        gap: 5px;
    }
    .action-buttons .btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 5px;
    }
    .badge-lg {
        font-size: 0.9rem;
        padding: 0.4rem 0.6rem;
    }
    .tab-content {
        padding-top: 20px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="card card-primary card-outline card-tabs">
                <div class="card-header p-0 pt-1 border-bottom-0">
                    <ul class="nav nav-tabs nav-tabs-custom" id="item-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="details-tab" data-toggle="pill" href="#details" role="tab" aria-controls="details" aria-selected="true">
                                <i class="fas fa-info-circle"></i> معلومات الصنف
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="units-tab" data-toggle="pill" href="#units" role="tab" aria-controls="units" aria-selected="false">
                                <i class="fas fa-balance-scale"></i> وحدات الصنف
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="stock-tab" data-toggle="pill" href="#stock" role="tab" aria-controls="stock" aria-selected="false">
                                <i class="fas fa-warehouse"></i> توزيع المخزون
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="transactions-tab" data-toggle="pill" href="#transactions" role="tab" aria-controls="transactions" aria-selected="false">
                                <i class="fas fa-exchange-alt"></i> حركات المخزون
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="item-tabsContent">
                        <!-- تبويب معلومات الصنف -->
                        <div class="tab-pane fade show active" id="details" role="tabpanel" aria-labelledby="details-tab">
                            <div class="row mb-4">
                                <div class="col-md-3 col-sm-6 col-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info-light"><i class="fas fa-boxes"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الكمية الحالية</span>
                                            @php
                                                $totalQuantity = 0;
                                                if ($item->inventory_stocks) {
                                                    foreach ($item->inventory_stocks as $stock) {
                                                        $totalQuantity += $stock->quantity;
                                                    }
                                                }
                                            @endphp
                                            <span class="info-box-number">{{ $totalQuantity }} {{ $item->base_unit ? $item->base_unit->name : '' }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 col-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success-light"><i class="fas fa-money-bill-wave"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">سعر البيع</span>
                                            <span class="info-box-number">{{ $item->selling_price }} {{ auth()->user()->company->currency }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 col-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-warning-light"><i class="fas fa-shopping-cart"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">سعر الشراء</span>
                                            <span class="info-box-number">{{ $item->purchase_price }} {{ auth()->user()->company->currency }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 col-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-danger-light"><i class="fas fa-exclamation-triangle"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الحد الأدنى للكمية</span>
                                            <span class="info-box-number">{{ $item->min_stock_level }} {{ $item->base_unit ? $item->base_unit->name : '' }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card card-outline card-primary">
                                        <div class="card-header">
                                            <h5 class="card-title">معلومات أساسية</h5>
                                        </div>
                                        <div class="card-body">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 30%">الاسم</th>
                                                    <td>{{ $item->name }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الرمز (SKU)</th>
                                                    <td>{{ $item->sku }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الفئة</th>
                                                    <td>{{ $item->category ? $item->category->name : 'غير مصنف' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>المورد</th>
                                                    <td>غير محدد</td>
                                                </tr>
                                                <tr>
                                                    <th>الوصف</th>
                                                    <td>{{ $item->description ?? 'لا يوجد وصف' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الحالة</th>
                                                    <td>
                                                        @if($item->is_active)
                                                            <span class="badge badge-success badge-lg">نشط</span>
                                                        @else
                                                            <span class="badge badge-danger badge-lg">غير نشط</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>تاريخ الإضافة</th>
                                                    <td>{{ $item->created_at->format('Y-m-d') }}</td>
                                                </tr>
                                                <tr>
                                                    <th>آخر تحديث</th>
                                                    <td>{{ $item->updated_at->format('Y-m-d') }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    @if($item->image)
                                    <div class="card card-outline card-primary">
                                        <div class="card-header">
                                            <h5 class="card-title">صورة العنصر</h5>
                                        </div>
                                        <div class="card-body text-center">
                                            <img src="{{ asset('storage/' . $item->image) }}" alt="{{ $item->name }}" class="img-fluid" style="max-height: 300px;">
                                        </div>
                                    </div>
                                    @else
                                    <div class="card card-outline card-primary">
                                        <div class="card-header">
                                            <h5 class="card-title">معلومات المخزون</h5>
                                        </div>
                                        <div class="card-body">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 30%">الكمية الحالية</th>
                                                    <td>{{ $totalQuantity }} {{ $item->base_unit ? $item->base_unit->name : '' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الحد الأدنى للكمية</th>
                                                    <td>{{ $item->min_stock_level }} {{ $item->base_unit ? $item->base_unit->name : '' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>سعر الشراء</th>
                                                    <td>{{ $item->purchase_price }} {{ auth()->user()->company->currency }}</td>
                                                </tr>
                                                <tr>
                                                    <th>سعر البيع</th>
                                                    <td>{{ $item->selling_price }} {{ auth()->user()->company->currency }}</td>
                                                </tr>
                                                <tr>
                                                    <th>القيمة الإجمالية</th>
                                                    <td>{{ $totalQuantity * $item->purchase_price }} {{ auth()->user()->company->currency }}</td>
                                                </tr>
                                                <tr>
                                                    <th>موقع التخزين</th>
                                                    <td>
                                                        @if ($item->inventory_stocks && $item->inventory_stocks->count() > 0)
                                                            @foreach ($item->inventory_stocks as $stock)
                                                                {{ $stock->warehouse ? $stock->warehouse->name : 'غير محدد' }}
                                                                @if ($stock->location_code) ({{ $stock->location_code }}) @endif
                                                                @if (!$loop->last), @endif
                                                            @endforeach
                                                        @else
                                                            غير محدد
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- تبويب وحدات الصنف -->
                        <div class="tab-pane fade" id="units" role="tabpanel" aria-labelledby="units-tab">
                            <div class="row mb-3">
                                <div class="col-12">
                                    <div class="action-buttons">
                                        <a href="{{ route('inventory.items.units.create', $item->id) }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> إضافة وحدة جديدة
                                        </a>
                                        <a href="{{ route('inventory.items.units.index', $item->id) }}" class="btn btn-info">
                                            <i class="fas fa-list"></i> عرض كل الوحدات
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="card card-outline card-primary">
                                <div class="card-header">
                                    <h5 class="card-title">وحدات الصنف</h5>
                                </div>
                                <div class="card-body">
                                    @if(isset($itemUnits) && count($itemUnits) > 0)
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الوحدة</th>
                                                    <th>معامل التحويل</th>
                                                    <th>الوحدة الافتراضية</th>
                                                    <th>وحدة الشراء</th>
                                                    <th>وحدة البيع</th>
                                                    <th>وحدة المخزون</th>
                                                    <th>سعر الشراء</th>
                                                    <th>سعر البيع</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($itemUnits as $index => $itemUnit)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $itemUnit->inventory_unit->name }}</td>
                                                    <td>{{ $itemUnit->conversion_factor }}</td>
                                                    <td>
                                                        @if($itemUnit->is_default)
                                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                                        @else
                                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($itemUnit->is_purchase_unit)
                                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                                        @else
                                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($itemUnit->is_sales_unit)
                                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                                        @else
                                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($itemUnit->is_inventory_unit)
                                                        <span class="badge badge-success"><i class="fas fa-check"></i></span>
                                                        @else
                                                        <span class="badge badge-secondary"><i class="fas fa-times"></i></span>
                                                        @endif
                                                    </td>
                                                    <td>{{ number_format($itemUnit->purchase_price, 2) }}</td>
                                                    <td>{{ number_format($itemUnit->selling_price, 2) }}</td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="{{ route('inventory.items.units.edit', ['itemId' => $item->id, 'id' => $itemUnit->id]) }}" class="btn btn-sm btn-warning">
                                                                <i class="fas fa-edit"></i> تعديل
                                                            </a>
                                                            <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $itemUnit->id }}">
                                                                <i class="fas fa-trash"></i> حذف
                                                            </button>
                                                        </div>
                                                        
                                                        <!-- Modal -->
                                                        <div class="modal fade" id="deleteModal{{ $itemUnit->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $itemUnit->id }}" aria-hidden="true">
                                                            <div class="modal-dialog" role="document">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="deleteModalLabel{{ $itemUnit->id }}">تأكيد الحذف</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        هل أنت متأكد من حذف وحدة "{{ $itemUnit->inventory_unit->name }}" من الصنف؟
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                        <form action="{{ route('inventory.items.units.destroy', ['itemId' => $item->id, 'id' => $itemUnit->id]) }}" method="POST">
                                                                            @csrf
                                                                            @method('DELETE')
                                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @else
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> لا توجد وحدات مرتبطة بهذا الصنف.
                                        <a href="{{ route('inventory.items.units.create', $item->id) }}" class="btn btn-sm btn-primary mr-2">
                                            <i class="fas fa-plus"></i> إضافة وحدة جديدة
                                        </a>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- تبويب توزيع المخزون -->
                        <div class="tab-pane fade" id="stock" role="tabpanel" aria-labelledby="stock-tab">
                            <div class="card card-outline card-primary">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع المخزون</h5>
                                </div>
                                <div class="card-body">
                                    @if($item->inventory_stocks && $item->inventory_stocks->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>المستودع</th>
                                                    <th>الكمية</th>
                                                    <th>الكمية المحجوزة</th>
                                                    <th>الكمية المتاحة</th>
                                                    <th>موقع التخزين</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($item->inventory_stocks as $stock)
                                                <tr>
                                                    <td>{{ $stock->id }}</td>
                                                    <td>{{ $stock->warehouse ? $stock->warehouse->name : 'غير محدد' }}</td>
                                                    <td>{{ $stock->quantity }} {{ $item->base_unit ? $item->base_unit->name : '' }}</td>
                                                    <td>{{ $stock->reserved_quantity }} {{ $item->base_unit ? $item->base_unit->name : '' }}</td>
                                                    <td>{{ $stock->quantity - $stock->reserved_quantity }} {{ $item->base_unit ? $item->base_unit->name : '' }}</td>
                                                    <td>{{ $stock->location_code ?? 'غير محدد' }}</td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="#" class="btn btn-sm btn-info">
                                                                <i class="fas fa-eye"></i> عرض
                                                            </a>
                                                            <a href="#" class="btn btn-sm btn-warning">
                                                                <i class="fas fa-edit"></i> تعديل
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @else
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> لا توجد سجلات مخزون لهذا العنصر.
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- تبويب حركات المخزون -->
                        <div class="tab-pane fade" id="transactions" role="tabpanel" aria-labelledby="transactions-tab">
                            <div class="card card-outline card-primary">
                                <div class="card-header">
                                    <h5 class="card-title">حركات المخزون</h5>
                                </div>
                                <div class="card-body">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> سيتم عرض حركات المخزون لهذا الصنف هنا.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">الإجراءات المتاحة</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 col-sm-6 mb-3">
                            <a href="{{ route('inventory.items.edit', $item->id) }}" class="btn btn-primary btn-block">
                                <i class="fas fa-edit"></i> تعديل الصنف
                            </a>
                        </div>
                        <div class="col-md-3 col-sm-6 mb-3">
                            <a href="{{ route('inventory.items.units.create', $item->id) }}" class="btn btn-success btn-block">
                                <i class="fas fa-plus"></i> إضافة وحدة جديدة
                            </a>
                        </div>
                        <div class="col-md-3 col-sm-6 mb-3">
                            <a href="{{ route('inventory.items.units.index', $item->id) }}" class="btn btn-info btn-block">
                                <i class="fas fa-balance-scale"></i> إدارة وحدات الصنف
                            </a>
                        </div>
                        <div class="col-md-3 col-sm-6 mb-3">
                            <a href="{{ route('inventory.items.index') }}" class="btn btn-secondary btn-block">
                                <i class="fas fa-arrow-right"></i> العودة للقائمة
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        // تفعيل التبويبات
        $('#item-tabs a').on('click', function (e) {
            e.preventDefault();
            $(this).tab('show');
        });

        // الحفاظ على التبويب النشط بعد تحديث الصفحة
        var hash = window.location.hash;
        if (hash) {
            $('#item-tabs a[href="' + hash + '"]').tab('show');
        }

        // تحديث الرابط عند تغيير التبويب
        $('#item-tabs a').on('shown.bs.tab', function (e) {
            window.location.hash = e.target.hash;
        });
    });
</script>
@endsection