@extends('layouts.app')

@section('title', request()->has('link_unit') ? 'اختر صنف لربط وحدة به' : 'عناصر المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ request()->has('link_unit') ? 'اختر صنف لربط وحدة به' : 'عناصر المخزون' }}</h3>
                    <div class="card-tools">
                        @if(request()->has('link_unit'))
                            <a href="{{ route('inventory.item-units.index') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-right"></i> العودة إلى وحدات الأصناف
                            </a>
                        @else
                            <a href="{{ route('inventory.items.create') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> إضافة عنصر جديد
                            </a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    @if(request()->has('link_unit'))
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> اختر صنفًا من القائمة أدناه لربط وحدة به
                    </div>
                    @endif
                    
                    @if($items->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>الرمز</th>
                                    <th>الفئة</th>
                                    <th>الكمية</th>
                                    <th>سعر الوحدة</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->sku }}</td>
                                    <td>{{ $item->category ? $item->category->name : 'غير مصنف' }}</td>
                                    <td>
                                        @php
                                            $totalQuantity = 0;
                                            if ($item->inventory_stocks) {
                                                foreach ($item->inventory_stocks as $stock) {
                                                    $totalQuantity += $stock->quantity;
                                                }
                                            }
                                        @endphp
                                        {{ $totalQuantity }} {{ $item->unit }}
                                    </td>
                                    <td>{{ $item->purchase_price }} {{ auth()->user()->company->currency }}</td>
                                    <td>
                                        @if($item->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if(request()->has('link_unit'))
                                            <a href="{{ route('inventory.item-units.create', $item->id) }}?link_unit=1" class="btn btn-success btn-sm">
                                                <i class="fas fa-link"></i> ربط وحدة
                                            </a>
                                        @else
                                            <a href="{{ route('inventory.items.show', $item->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('inventory.items.edit', $item->id) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('inventory.items.destroy', $item->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا العنصر؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="alert alert-info">
                        لا توجد عناصر للعرض.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    /* تحسين مظهر الجدول عند اختيار صنف لربط وحدة به */
    @if(request()->has('link_unit'))
    .table tr:hover {
        background-color: #f0f8ff !important;
        cursor: pointer;
    }
    @endif
</style>
@endpush

@push('scripts')
@if(request()->has('link_unit'))
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // إضافة تأثير عند تمرير المؤشر على الصفوف
        var tableRows = document.querySelectorAll('table tbody tr');
        tableRows.forEach(function(row) {
            row.addEventListener('click', function() {
                var linkButton = this.querySelector('a.btn-success');
                if (linkButton) {
                    window.location.href = linkButton.getAttribute('href');
                }
            });
        });
    });
</script>
@endif
@endpush