@extends('layouts.modern')

@section('title', 'لوحة معلومات المخزون')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">لوحة معلومات المخزون</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item active">لوحة معلومات المخزون</li>
    </ol>

    <!-- بطاقات الإحصائيات -->
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $totalItems }}</h5>
                            <div class="small">إجمالي العناصر</div>
                        </div>
                        <div>
                            <i class="fas fa-boxes fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.items.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $lowStockCount }}</h5>
                            <div class="small">عناصر منخفضة المخزون</div>
                        </div>
                        <div>
                            <i class="fas fa-exclamation-triangle fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.alerts.low-stock') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ number_format($stockValue, 2) }}</h5>
                            <div class="small">قيمة المخزون (ريال)</div>
                        </div>
                        <div>
                            <i class="fas fa-money-bill-wave fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.stock.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-info text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $pendingPOCount }}</h5>
                            <div class="small">طلبات شراء معلقة</div>
                        </div>
                        <div>
                            <i class="fas fa-shopping-cart fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.purchase-orders.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- صف ثاني من البطاقات للميزات الجديدة -->
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-info text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $activeCounts ?? 0 }}</h5>
                            <div class="small">جلسات الجرد النشطة</div>
                        </div>
                        <div>
                            <i class="fas fa-clipboard-check fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.counts.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-secondary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $expiringItems ?? 0 }}</h5>
                            <div class="small">منتجات قاربت على الانتهاء</div>
                        </div>
                        <div>
                            <i class="fas fa-calendar-times fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.alerts.expiry') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-dark text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $pendingAdjustments ?? 0 }}</h5>
                            <div class="small">تعديلات معلقة</div>
                        </div>
                        <div>
                            <i class="fas fa-balance-scale fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.stock.adjust-form') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $alertSettings ?? 0 }}</h5>
                            <div class="small">إعدادات التنبيهات</div>
                        </div>
                        <div>
                            <i class="fas fa-bell fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.alerts.settings') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- العناصر منخفضة المخزون -->
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-exclamation-triangle me-1"></i>
                    العناصر منخفضة المخزون
                </div>
                <div class="card-body">
                    @if($lowStockItems->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>العنصر</th>
                                        <th>الفئة</th>
                                        <th>المخزون الحالي</th>
                                        <th>الحد الأدنى</th>
                                        <th>المستودع</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($lowStockItems as $item)
                                        @foreach($item->stocks as $stock)
                                            @if($stock->quantity <= $item->min_stock)
                                                <tr>
                                                    <td>{{ $item->name }}</td>
                                                    <td>{{ $item->category->name ?? 'غير مصنف' }}</td>
                                                    <td class="text-danger">{{ $stock->quantity }}</td>
                                                    <td>{{ $item->min_stock }}</td>
                                                    <td>{{ $stock->warehouse->name }}</td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-success">
                            لا توجد عناصر منخفضة المخزون حالياً.
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-cog"></i> إدارة قواعد الشراء التلقائي
                    </a>
                    <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-sm btn-success">
                        <i class="fas fa-sync"></i> تشغيل فحص المخزون
                    </a>
                </div>
            </div>
        </div>

        <!-- آخر المعاملات -->
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-exchange-alt me-1"></i>
                    آخر معاملات المخزون
                </div>
                <div class="card-body">
                    @if($recentTransactions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>التاريخ</th>
                                        <th>العنصر</th>
                                        <th>النوع</th>
                                        <th>الكمية</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentTransactions as $transaction)
                                        <tr>
                                            <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                            <td>{{ $transaction->item->name }}</td>
                                            <td>
                                                @if($transaction->type == 'in')
                                                    <span class="badge bg-success">وارد</span>
                                                @elseif($transaction->type == 'out')
                                                    <span class="badge bg-danger">صادر</span>
                                                @elseif($transaction->type == 'transfer')
                                                    <span class="badge bg-info">نقل</span>
                                                @elseif($transaction->type == 'adjustment')
                                                    <span class="badge bg-warning">تعديل</span>
                                                @endif
                                            </td>
                                            <td>{{ $transaction->quantity }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            لا توجد معاملات حديثة.
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.transactions.index') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-list"></i> عرض جميع المعاملات
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- آخر طلبات الشراء -->
        <div class="col-xl-12">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-shopping-cart me-1"></i>
                    آخر طلبات الشراء
                </div>
                <div class="card-body">
                    @if($recentPurchaseOrders->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>رقم الطلب</th>
                                        <th>المورد</th>
                                        <th>المستودع</th>
                                        <th>تاريخ الطلب</th>
                                        <th>تاريخ التسليم المتوقع</th>
                                        <th>الحالة</th>
                                        <th>المبلغ الإجمالي</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentPurchaseOrders as $order)
                                        <tr>
                                            <td>{{ $order->po_number }}</td>
                                            <td>{{ $order->supplier->name }}</td>
                                            <td>{{ $order->warehouse->name }}</td>
                                            <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                            <td>{{ $order->expected_delivery_date->format('Y-m-d') }}</td>
                                            <td>
                                                @if($order->status == 'draft')
                                                    <span class="badge bg-secondary">مسودة</span>
                                                @elseif($order->status == 'approved')
                                                    <span class="badge bg-primary">معتمد</span>
                                                @elseif($order->status == 'partial')
                                                    <span class="badge bg-info">استلام جزئي</span>
                                                @elseif($order->status == 'completed')
                                                    <span class="badge bg-success">مكتمل</span>
                                                @elseif($order->status == 'cancelled')
                                                    <span class="badge bg-danger">ملغي</span>
                                                @endif
                                            </td>
                                            <td>{{ number_format($order->total_amount, 2) }}</td>
                                            <td>
                                                <a href="{{ route('inventory.purchase-orders.show', $order->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            لا توجد طلبات شراء حديثة.
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.purchase-orders.index') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-list"></i> عرض جميع طلبات الشراء
                    </a>
                    <a href="{{ route('inventory.purchase-orders.create') }}" class="btn btn-sm btn-success">
                        <i class="fas fa-plus"></i> إنشاء طلب شراء جديد
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5>الشراء التلقائي</h5>
                            <p class="text-muted">إدارة قواعد الشراء التلقائي وتشغيل فحص المخزون</p>
                        </div>
                        <div>
                            <a href="{{ route('inventory.auto-purchase.analytics') }}" class="btn btn-info me-2">
                                <i class="fas fa-chart-line"></i> لوحة معلومات الشراء التلقائي
                            </a>
                            <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-primary me-2">
                                <i class="fas fa-cogs"></i> إدارة قواعد الشراء التلقائي
                            </a>
                            <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-success">
                                <i class="fas fa-sync"></i> تشغيل فحص المخزون
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection