@extends('layouts.modern')

@section('title', 'Inventory Count Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Inventory Count: {{ $count->count_number }}</h3>
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="{{ route('inventory.counts.index') }}" class="btn btn-default">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                            <a href="{{ route('inventory.counts.print', $count->id) }}" class="btn btn-info" target="_blank">
                                <i class="fas fa-print"></i> Print
                            </a>
                            @if($count->status == 'draft')
                                <a href="{{ route('inventory.counts.count', $count->id) }}" class="btn btn-primary">
                                    <i class="fas fa-clipboard-check"></i> Continue Counting
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">Count Information</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">Count Number</th>
                                            <td>{{ $count->count_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>Warehouse</th>
                                            <td>{{ $count->warehouse->name }} ({{ $count->warehouse->code }})</td>
                                        </tr>
                                        <tr>
                                            <th>Count Date</th>
                                            <td>{{ $count->count_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td>
                                                @if($count->status == 'draft')
                                                    <span class="badge badge-warning">Draft</span>
                                                @elseif($count->status == 'completed')
                                                    <span class="badge badge-info">Completed</span>
                                                @elseif($count->status == 'approved')
                                                    <span class="badge badge-success">Approved</span>
                                                @elseif($count->status == 'cancelled')
                                                    <span class="badge badge-danger">Cancelled</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Created By</th>
                                            <td>{{ $count->createdBy->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Created At</th>
                                            <td>{{ $count->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        @if($count->approved_by)
                                        <tr>
                                            <th>Approved By</th>
                                            <td>{{ $count->approvedBy->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Approved At</th>
                                            <td>{{ $count->approved_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>Notes</th>
                                            <td>{{ $count->notes ?? 'N/A' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">Count Summary</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-info"><i class="fas fa-boxes"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Total Items</span>
                                                    <span class="info-box-number">{{ $count->total_items_count }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success"><i class="fas fa-clipboard-check"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Counted Items</span>
                                                    <span class="info-box-number">{{ $count->counted_items_count }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning"><i class="fas fa-exclamation-triangle"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Discrepancies</span>
                                                    <span class="info-box-number">{{ $count->discrepancy_items_count }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-primary"><i class="fas fa-percentage"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Completion</span>
                                                    <span class="info-box-number">{{ $count->completion_percentage }}%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" style="width: {{ $count->completion_percentage }}%;" aria-valuenow="{{ $count->completion_percentage }}" aria-valuemin="0" aria-valuemax="100">{{ $count->completion_percentage }}%</div>
                                    </div>
                                    
                                    <div class="mt-4">
                                        @if($count->status == 'draft')
                                            <form action="{{ route('inventory.counts.complete', $count->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to complete this count? No further changes will be allowed.')">
                                                    <i class="fas fa-check"></i> Complete Count
                                                </button>
                                            </form>
                                            <form action="{{ route('inventory.counts.cancel', $count->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to cancel this count? This action cannot be undone.')">
                                                    <i class="fas fa-times"></i> Cancel Count
                                                </button>
                                            </form>
                                        @elseif($count->status == 'completed')
                                            <form action="{{ route('inventory.counts.approve', $count->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to approve this count? This will adjust inventory levels based on counted quantities.')">
                                                    <i class="fas fa-check-double"></i> Approve & Adjust Inventory
                                                </button>
                                            </form>
                                            <form action="{{ route('inventory.counts.cancel', $count->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to cancel this count? This action cannot be undone.')">
                                                    <i class="fas fa-times"></i> Cancel Count
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-4">
                        <div class="card-header bg-light">
                            <h5 class="card-title">Count Items</h5>
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 250px;">
                                    <input type="text" id="itemSearch" class="form-control" placeholder="Search items...">
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="itemsTable">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>SKU</th>
                                            <th>System Quantity</th>
                                            <th>Counted Quantity</th>
                                            <th>Discrepancy</th>
                                            <th>Status</th>
                                            <th>Counted By</th>
                                            <th>Counted At</th>
                                            <th>Notes</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($count->items as $item)
                                            <tr class="{{ $item->has_discrepancy ? 'table-warning' : '' }}">
                                                <td>{{ $item->item->name }}</td>
                                                <td>{{ $item->item->sku }}</td>
                                                <td>{{ $item->system_quantity }}</td>
                                                <td>{{ $item->is_counted ? $item->counted_quantity : 'Not counted' }}</td>
                                                <td>
                                                    @if($item->is_counted)
                                                        @if($item->has_discrepancy)
                                                            <span class="text-{{ $item->discrepancy > 0 ? 'success' : 'danger' }}">
                                                                {{ $item->discrepancy > 0 ? '+' : '' }}{{ $item->discrepancy }} ({{ $item->discrepancy_percentage }}%)
                                                            </span>
                                                        @else
                                                            <span class="text-success">No discrepancy</span>
                                                        @endif
                                                    @else
                                                        -
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($item->is_counted)
                                                        <span class="badge badge-success">Counted</span>
                                                    @else
                                                        <span class="badge badge-secondary">Pending</span>
                                                    @endif
                                                </td>
                                                <td>{{ $item->counter->name ?? 'N/A' }}</td>
                                                <td>{{ $item->counted_at ? $item->counted_at->format('Y-m-d H:i') : 'N/A' }}</td>
                                                <td>{{ $item->notes ?? 'N/A' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Simple search functionality
        $("#itemSearch").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#itemsTable tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
</script>
@endpush
@endsection