<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Inventory Count Sheet - {{ $count->count_number }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
        }
        .document-title {
            font-size: 18px;
            margin: 10px 0;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table th {
            text-align: left;
            width: 150px;
            padding: 5px;
        }
        .info-table td {
            padding: 5px;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .items-table th, .items-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .items-table th {
            background-color: #f2f2f2;
        }
        .items-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
        .signature-section {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
        }
        .signature-box {
            width: 45%;
        }
        .signature-line {
            border-top: 1px solid #000;
            margin-top: 50px;
            padding-top: 5px;
        }
        @media print {
            body {
                padding: 0;
                margin: 0;
            }
            .no-print {
                display: none;
            }
            @page {
                margin: 1cm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px;">
        <button onclick="window.print();" style="padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer;">
            Print Count Sheet
        </button>
        <button onclick="window.close();" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 4px; cursor: pointer; margin-left: 10px;">
            Close
        </button>
    </div>

    <div class="header">
        <div class="company-name">{{ $count->company->name }}</div>
        <div class="document-title">Inventory Count Sheet</div>
    </div>

    <table class="info-table">
        <tr>
            <th>Count Number:</th>
            <td>{{ $count->count_number }}</td>
            <th>Warehouse:</th>
            <td>{{ $count->warehouse->name }} ({{ $count->warehouse->code }})</td>
        </tr>
        <tr>
            <th>Count Date:</th>
            <td>{{ $count->count_date->format('Y-m-d') }}</td>
            <th>Status:</th>
            <td>
                @if($count->status == 'draft')
                    Draft
                @elseif($count->status == 'completed')
                    Completed
                @elseif($count->status == 'approved')
                    Approved
                @elseif($count->status == 'cancelled')
                    Cancelled
                @endif
            </td>
        </tr>
        <tr>
            <th>Created By:</th>
            <td>{{ $count->createdBy->name }}</td>
            <th>Created At:</th>
            <td>{{ $count->created_at->format('Y-m-d H:i') }}</td>
        </tr>
        @if($count->approved_by)
        <tr>
            <th>Approved By:</th>
            <td>{{ $count->approvedBy->name }}</td>
            <th>Approved At:</th>
            <td>{{ $count->approved_at->format('Y-m-d H:i') }}</td>
        </tr>
        @endif
        @if($count->notes)
        <tr>
            <th>Notes:</th>
            <td colspan="3">{{ $count->notes }}</td>
        </tr>
        @endif
    </table>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 30%;">Item</th>
                <th style="width: 15%;">SKU</th>
                <th style="width: 10%;">System Qty</th>
                <th style="width: 10%;">Counted Qty</th>
                <th style="width: 10%;">Discrepancy</th>
                <th style="width: 20%;">Notes</th>
            </tr>
        </thead>
        <tbody>
            @foreach($count->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item->item->name }}</td>
                    <td>{{ $item->item->sku }}</td>
                    <td>{{ $item->system_quantity }}</td>
                    <td>
                        @if($count->status == 'draft' && !$item->is_counted)
                            ____________
                        @else
                            {{ $item->counted_quantity }}
                        @endif
                    </td>
                    <td>
                        @if($item->is_counted)
                            {{ $item->discrepancy > 0 ? '+' : '' }}{{ $item->discrepancy }}
                        @else
                            ____________
                        @endif
                    </td>
                    <td>
                        @if($count->status == 'draft' && !$item->is_counted)
                            ________________________
                        @else
                            {{ $item->notes ?? '' }}
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="signature-section">
        <div class="signature-box">
            <div class="signature-line">Counted By</div>
        </div>
        <div class="signature-box">
            <div class="signature-line">Verified By</div>
        </div>
    </div>

    <div class="footer">
        <p>Printed on: {{ date('Y-m-d H:i:s') }}</p>
        <p>{{ config('app.name') }} - Inventory Management System</p>
    </div>
</body>
</html>