@extends('layouts.modern')

@section('title', 'جرد المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-clipboard-list ml-2"></i>
                        قائمة عمليات جرد المخزون
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.counts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus ml-1"></i> جرد جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- بحث وفلترة -->
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <div class="input-group">
                                <input type="text" id="searchInput" class="form-control" placeholder="بحث عن رقم الجرد أو المستودع...">
                                <div class="input-group-append">
                                    <button class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <select id="statusFilter" class="form-control">
                                <option value="">كل الحالات</option>
                                <option value="draft">مسودة</option>
                                <option value="completed">مكتمل</option>
                                <option value="approved">معتمد</option>
                                <option value="cancelled">ملغي</option>
                            </select>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover" id="countsTable">
                            <thead class="bg-primary text-white">
                                <tr>
                                    <th>رقم الجرد</th>
                                    <th>المستودع</th>
                                    <th>التاريخ</th>
                                    <th>الحالة</th>
                                    <th>التقدم</th>
                                    <th>بواسطة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($counts as $count)
                                    <tr data-status="{{ $count->status }}">
                                        <td>{{ $count->count_number }}</td>
                                        <td>{{ $count->warehouse->name }}</td>
                                        <td>{{ $count->count_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($count->status == 'draft')
                                                <span class="badge badge-warning">مسودة</span>
                                            @elseif($count->status == 'completed')
                                                <span class="badge badge-info">مكتمل</span>
                                            @elseif($count->status == 'approved')
                                                <span class="badge badge-success">معتمد</span>
                                            @elseif($count->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar {{ $count->completion_percentage == 100 ? 'bg-success' : 'bg-primary' }}" 
                                                     role="progressbar" 
                                                     style="width: {{ $count->completion_percentage }}%;" 
                                                     aria-valuenow="{{ $count->completion_percentage }}" 
                                                     aria-valuemin="0" 
                                                     aria-valuemax="100">
                                                    {{ $count->completion_percentage }}%
                                                </div>
                                            </div>
                                            <small class="text-muted">{{ $count->counted_items_count }} / {{ $count->total_items_count }} صنف</small>
                                        </td>
                                        <td>{{ $count->createdBy->name }}</td>
                                        <td>{{ $count->created_at->format('Y-m-d H:i') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('inventory.counts.show', $count->id) }}" class="btn btn-sm btn-info" title="عرض التفاصيل">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($count->status == 'draft')
                                                    <a href="{{ route('inventory.counts.count', $count->id) }}" class="btn btn-sm btn-primary" title="متابعة الجرد">
                                                        <i class="fas fa-clipboard-check"></i>
                                                    </a>
                                                @endif
                                                <a href="{{ route('inventory.counts.print', $count->id) }}" class="btn btn-sm btn-secondary" target="_blank" title="طباعة">
                                                    <i class="fas fa-print"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد عمليات جرد مسجلة.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $counts->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // بحث في الجدول
        $("#searchInput").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#countsTable tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        
        // فلترة حسب الحالة
        $("#statusFilter").on("change", function() {
            var value = $(this).val().toLowerCase();
            if (value === "") {
                $("#countsTable tbody tr").show();
            } else {
                $("#countsTable tbody tr").filter(function() {
                    $(this).toggle($(this).data("status") === value)
                });
            }
        });
        
        // تلميحات للأزرار
        $('[title]').tooltip();
    });
</script>
@endpush
@endsection