@extends('layouts.modern')

@section('title', 'إنشاء جرد مخزون جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-clipboard-list ml-2"></i>
                        إنشاء جرد مخزون جديد
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.counts.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right ml-1"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-8">
                            <form action="{{ route('inventory.counts.store') }}" method="POST">
                                @csrf
                                
                                <div class="card card-body bg-light mb-3">
                                    <div class="form-group">
                                        <label for="warehouse_id">المستودع <span class="text-danger">*</span></label>
                                        <select name="warehouse_id" id="warehouse_id" class="form-control select2 @error('warehouse_id') is-invalid @enderror" required>
                                            <option value="">اختر المستودع</option>
                                            @foreach($warehouses as $warehouse)
                                                <option value="{{ $warehouse->id }}" {{ old('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                                    {{ $warehouse->name }} ({{ $warehouse->code }})
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('warehouse_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="count_date">تاريخ الجرد <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                            </div>
                                            <input type="date" name="count_date" id="count_date" class="form-control @error('count_date') is-invalid @enderror" value="{{ old('count_date', date('Y-m-d')) }}" required>
                                        </div>
                                        @error('count_date')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="notes">ملاحظات</label>
                                        <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3" placeholder="أدخل أي ملاحظات خاصة بعملية الجرد">{{ old('notes') }}</textarea>
                                        @error('notes')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        <i class="fas fa-save ml-1"></i> إنشاء جرد جديد
                                    </button>
                                    <a href="{{ route('inventory.counts.index') }}" class="btn btn-default btn-lg">
                                        <i class="fas fa-times ml-1"></i> إلغاء
                                    </a>
                                </div>
                            </form>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card card-primary">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-info-circle ml-1"></i>
                                        معلومات مهمة
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="callout callout-info">
                                        <h5>ماذا يحدث عند إنشاء جرد جديد؟</h5>
                                        <p>عند إنشاء جرد جديد، سيتم تضمين جميع الأصناف الموجودة حالياً في المستودع المحدد. ستتمكن من عد الأصناف وتسجيل الفروقات بين الكميات الفعلية والكميات المسجلة في النظام.</p>
                                    </div>
                                    
                                    <div class="callout callout-warning">
                                        <h5>خطوات عملية الجرد:</h5>
                                        <ol>
                                            <li>إنشاء جرد جديد</li>
                                            <li>عد الأصناف وتسجيل الكميات الفعلية</li>
                                            <li>إكمال عملية الجرد</li>
                                            <li>اعتماد الجرد وتعديل المخزون</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // تفعيل Select2 لتحسين قوائم الاختيار
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
    });
</script>
@endpush
@endsection