@extends('layouts.modern')

@section('title', 'جرد الأصناف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-clipboard-list ml-2"></i>
                        جرد المخزون: {{ $count->count_number }}
                    </h3>
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="{{ route('inventory.counts.show', $count->id) }}" class="btn btn-default">
                                <i class="fas fa-arrow-right ml-1"></i> العودة للتفاصيل
                            </a>
                            <a href="{{ route('inventory.counts.print', $count->id) }}" class="btn btn-info" target="_blank">
                                <i class="fas fa-print ml-1"></i> طباعة ورقة الجرد
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card card-outline card-info">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">
                                        <i class="fas fa-info-circle ml-1"></i>
                                        معلومات الجرد
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-striped">
                                        <tr>
                                            <th style="width: 30%">رقم الجرد</th>
                                            <td>{{ $count->count_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>{{ $count->warehouse->name }} ({{ $count->warehouse->code }})</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الجرد</th>
                                            <td>{{ $count->count_date->format('Y-m-d') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card-outline card-success">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">
                                        <i class="fas fa-chart-pie ml-1"></i>
                                        التقدم
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="progress mb-3" style="height: 25px;">
                                        <div class="progress-bar {{ $count->completion_percentage == 100 ? 'bg-success' : 'bg-primary' }}" 
                                             role="progressbar" 
                                             style="width: {{ $count->completion_percentage }}%;" 
                                             aria-valuenow="{{ $count->completion_percentage }}" 
                                             aria-valuemin="0" 
                                             aria-valuemax="100">
                                            {{ $count->completion_percentage }}%
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-info"><i class="fas fa-boxes"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">إجمالي الأصناف</span>
                                                    <span class="info-box-number">{{ $count->total_items_count }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success"><i class="fas fa-clipboard-check"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">الأصناف المجرودة</span>
                                                    <span class="info-box-number">{{ $count->counted_items_count }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card card-outline card-primary">
                        <div class="card-header bg-light">
                            <h5 class="card-title">
                                <i class="fas fa-list ml-1"></i>
                                قائمة الأصناف
                            </h5>
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 250px;">
                                    <input type="text" id="itemSearch" class="form-control" placeholder="بحث باسم الصنف أو الرمز...">
                                    <div class="input-group-append">
                                        <button class="btn btn-default">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover" id="itemsTable">
                                    <thead class="bg-primary text-white">
                                        <tr>
                                            <th>الصنف</th>
                                            <th>الرمز</th>
                                            <th>الكمية في النظام</th>
                                            <th>الكمية المجرودة</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($count->items as $item)
                                            <tr class="{{ $item->is_counted ? '' : 'table-light' }}">
                                                <td>{{ $item->item->name }}</td>
                                                <td>{{ $item->item->sku }}</td>
                                                <td>{{ $item->system_quantity }}</td>
                                                <td>
                                                    @if($item->is_counted)
                                                        {{ $item->counted_quantity }}
                                                    @else
                                                        <span class="text-muted">لم يتم الجرد</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($item->is_counted)
                                                        <span class="badge badge-success">تم الجرد</span>
                                                    @else
                                                        <span class="badge badge-secondary">قيد الانتظار</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm {{ $item->is_counted ? 'btn-info' : 'btn-primary' }} count-item-btn" 
                                                        data-toggle="modal" 
                                                        data-target="#countItemModal"
                                                        data-id="{{ $item->id }}"
                                                        data-item-name="{{ $item->item->name }}"
                                                        data-item-sku="{{ $item->item->sku }}"
                                                        data-system-quantity="{{ $item->system_quantity }}"
                                                        data-counted-quantity="{{ $item->counted_quantity }}"
                                                        data-notes="{{ $item->notes }}">
                                                        <i class="fas fa-clipboard-check ml-1"></i> {{ $item->is_counted ? 'تعديل الجرد' : 'جرد الصنف' }}
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <span class="badge badge-success ml-1">تم الجرد</span> تم جرد الصنف
                                    <span class="badge badge-secondary mr-3 ml-1">قيد الانتظار</span> لم يتم جرد الصنف بعد
                                </div>
                                <div>
                                    <span>إجمالي الأصناف: {{ $count->total_items_count }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4 text-center">
                        <a href="{{ route('inventory.counts.show', $count->id) }}" class="btn btn-default btn-lg ml-2">
                            <i class="fas fa-arrow-right ml-1"></i> العودة للتفاصيل
                        </a>
                        <form action="{{ route('inventory.counts.complete', $count->id) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-success btn-lg" onclick="return confirm('هل أنت متأكد من إكمال عملية الجرد؟ لن يسمح بإجراء أي تغييرات بعد ذلك.')">
                                <i class="fas fa-check ml-1"></i> إكمال الجرد
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- نافذة جرد الصنف -->
<div class="modal fade" id="countItemModal" tabindex="-1" role="dialog" aria-labelledby="countItemModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="countItemModalLabel">جرد الصنف</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="countItemForm" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label>اسم الصنف</label>
                        <input type="text" class="form-control" id="itemName" readonly>
                    </div>
                    <div class="form-group">
                        <label>الرمز</label>
                        <input type="text" class="form-control" id="itemSku" readonly>
                    </div>
                    <div class="form-group">
                        <label>الكمية في النظام</label>
                        <input type="text" class="form-control" id="systemQuantity" readonly>
                    </div>
                    <div class="form-group">
                        <label for="counted_quantity">الكمية المجرودة <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-calculator"></i></span>
                            </div>
                            <input type="number" name="counted_quantity" id="counted_quantity" class="form-control" step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="notes">ملاحظات</label>
                        <textarea name="notes" id="notes" class="form-control" rows="3" placeholder="أدخل أي ملاحظات خاصة بجرد هذا الصنف"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save ml-1"></i> حفظ الجرد
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // وظيفة البحث في الجدول
        $("#itemSearch").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#itemsTable tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        
        // معالجة نافذة جرد الصنف
        $('.count-item-btn').click(function() {
            var id = $(this).data('id');
            var itemName = $(this).data('item-name');
            var itemSku = $(this).data('item-sku');
            var systemQuantity = $(this).data('system-quantity');
            var countedQuantity = $(this).data('counted-quantity');
            var notes = $(this).data('notes');
            
            $('#itemName').val(itemName);
            $('#itemSku').val(itemSku);
            $('#systemQuantity').val(systemQuantity);
            $('#counted_quantity').val(countedQuantity);
            $('#notes').val(notes);
            
            var url = "{{ route('inventory.counts.update-item', ['id' => $count->id, 'itemId' => ':itemId']) }}";
            url = url.replace(':itemId', id);
            $('#countItemForm').attr('action', url);
        });
        
        // تلوين الصفوف حسب الحالة
        $("#itemsTable tbody tr").each(function() {
            if ($(this).find("td:eq(4)").text().trim() === "تم الجرد") {
                $(this).addClass("table-success");
            }
        });
    });
</script>
@endpush
@endsection