@extends('layouts.modern')

@section('title', 'نتيجة مسح الباركود')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.index') }}">إدارة الباركود</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.scan') }}">مسح الباركود</a></li>
        <li class="breadcrumb-item active">نتيجة المسح</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">نتيجة مسح الباركود: {{ $item->barcode }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.scan') }}" class="btn btn-info btn-sm">
                            <i class="fa fa-barcode"></i> مسح باركود جديد
                        </a>
                        <a href="{{ route('inventory.barcodes.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">معلومات العنصر</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">رمز العنصر</th>
                                            <td>{{ $item->sku }}</td>
                                        </tr>
                                        <tr>
                                            <th>اسم العنصر</th>
                                            <td>{{ $item->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الباركود</th>
                                            <td>{{ $item->barcode }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفئة</th>
                                            <td>{{ $item->category->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>وحدة القياس</th>
                                            <td>{{ $item->unit }}</td>
                                        </tr>
                                        <tr>
                                            <th>سعر الشراء</th>
                                            <td>{{ number_format($item->purchase_price, 2) }} {{ auth()->user()->company->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>سعر البيع</th>
                                            <td>{{ number_format($item->selling_price, 2) }} {{ auth()->user()->company->currency }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">مستوى المخزون</h3>
                                </div>
                                <div class="card-body">
                                    @if($stocks->isEmpty())
                                        <div class="alert alert-warning">
                                            <i class="fa fa-exclamation-triangle"></i> لا يوجد مخزون متاح لهذا العنصر.
                                        </div>
                                    @else
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>المستودع</th>
                                                    <th>الكمية المتاحة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($stocks as $stock)
                                                    <tr>
                                                        <td>{{ $stock->warehouse->name }}</td>
                                                        <td>{{ number_format($stock->quantity, 2) }} {{ $item->unit }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>إجمالي المخزون</th>
                                                    <th>{{ number_format($stocks->sum('quantity'), 2) }} {{ $item->unit }}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">إنشاء معاملة</h3>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('inventory.barcodes.create-transaction') }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="item_id" value="{{ $item->id }}">
                                        
                                        <div class="form-group">
                                            <label for="transaction_type">نوع المعاملة</label>
                                            <select name="transaction_type" id="transaction_type" class="form-control" required>
                                                <option value="">اختر نوع المعاملة</option>
                                                @foreach($transactionTypes as $key => $type)
                                                    <option value="{{ $key }}">{{ $type }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="warehouse_id">المستودع</label>
                                            <select name="warehouse_id" id="warehouse_id" class="form-control" required>
                                                <option value="">اختر المستودع</option>
                                                @foreach($warehouses as $warehouse)
                                                    <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        
                                        <div class="form-group to-warehouse-group" style="display: none;">
                                            <label for="to_warehouse_id">المستودع الهدف</label>
                                            <select name="to_warehouse_id" id="to_warehouse_id" class="form-control">
                                                <option value="">اختر المستودع الهدف</option>
                                                @foreach($warehouses as $warehouse)
                                                    <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="quantity">الكمية</label>
                                            <input type="number" name="quantity" id="quantity" class="form-control" step="0.01" min="0.01" value="1" required>
                                        </div>
                                        
                                        <div class="form-group unit-price-group">
                                            <label for="unit_price">سعر الوحدة</label>
                                            <input type="number" name="unit_price" id="unit_price" class="form-control" step="0.01" min="0" value="{{ $item->purchase_price }}">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="notes">ملاحظات</label>
                                            <textarea name="notes" id="notes" class="form-control" rows="2"></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fa fa-save"></i> إنشاء المعاملة
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    $(function() {
        // إظهار/إخفاء حقول إضافية بناءً على نوع المعاملة
        $('#transaction_type').on('change', function() {
            var transactionType = $(this).val();
            
            // إظهار/إخفاء حقل المستودع الهدف
            if (transactionType === 'transfer') {
                $('.to-warehouse-group').show();
                $('#to_warehouse_id').prop('required', true);
            } else {
                $('.to-warehouse-group').hide();
                $('#to_warehouse_id').prop('required', false);
            }
            
            // إظهار/إخفاء حقل سعر الوحدة
            if (transactionType === 'purchase' || transactionType === 'sale' || transactionType === 'return_from_customer' || transactionType === 'return_to_supplier') {
                $('.unit-price-group').show();
                
                // تعيين القيمة الافتراضية بناءً على نوع المعاملة
                if (transactionType === 'purchase' || transactionType === 'return_to_supplier') {
                    $('#unit_price').val('{{ $item->purchase_price }}');
                } else {
                    $('#unit_price').val('{{ $item->selling_price }}');
                }
            } else {
                $('.unit-price-group').hide();
                $('#unit_price').val('0');
            }
        });
        
        // منع اختيار نفس المستودع للمصدر والهدف
        $('#warehouse_id, #to_warehouse_id').on('change', function() {
            var warehouseId = $('#warehouse_id').val();
            var toWarehouseId = $('#to_warehouse_id').val();
            
            if (warehouseId && toWarehouseId && warehouseId === toWarehouseId) {
                alert('لا يمكن اختيار نفس المستودع للمصدر والهدف');
                $('#to_warehouse_id').val('');
            }
        });
    });
</script>
@endsection