@extends('layouts.modern')

@section('title', 'مسح الباركود')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.index') }}">إدارة الباركود</a></li>
        <li class="breadcrumb-item active">مسح الباركود</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">مسح الباركود</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mx-auto">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">مسح باركود العنصر</h3>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('inventory.barcodes.process-scan') }}" method="POST">
                                        @csrf
                                        <div class="form-group">
                                            <label for="barcode">الباركود</label>
                                            <div class="input-group">
                                                <input type="text" name="barcode" id="barcode" class="form-control" placeholder="قم بمسح الباركود أو إدخاله يدوياً" autofocus required>
                                                <div class="input-group-append">
                                                    <button type="submit" class="btn btn-primary">
                                                        <i class="fa fa-search"></i> بحث
                                                    </button>
                                                </div>
                                            </div>
                                            <small class="form-text text-muted">يمكنك إدخال رمز الباركود أو رمز العنصر (SKU)</small>
                                        </div>
                                    </form>
                                    
                                    <div class="alert alert-info mt-4">
                                        <i class="fa fa-info-circle"></i> قم بتوجيه قارئ الباركود إلى الباركود الموجود على العنصر، أو قم بإدخال الرمز يدوياً.
                                    </div>
                                    
                                    <div class="text-center mt-4">
                                        <i class="fas fa-barcode fa-5x text-primary"></i>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card mt-4">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">تعليمات</h3>
                                </div>
                                <div class="card-body">
                                    <ol>
                                        <li>قم بتوصيل قارئ الباركود بجهاز الكمبيوتر.</li>
                                        <li>تأكد من أن مؤشر الكتابة موجود في حقل الباركود.</li>
                                        <li>قم بمسح الباركود الموجود على العنصر.</li>
                                        <li>سيتم البحث عن العنصر تلقائياً وعرض معلوماته.</li>
                                        <li>يمكنك بعد ذلك إجراء العمليات المختلفة على العنصر مثل إضافة أو سحب كميات.</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    $(function() {
        // التركيز على حقل الباركود عند تحميل الصفحة
        $('#barcode').focus();
        
        // إرسال النموذج تلقائياً عند مسح الباركود (عند وجود قارئ باركود)
        $('#barcode').on('keydown', function(e) {
            if (e.keyCode === 13) { // Enter key
                e.preventDefault();
                $(this).closest('form').submit();
            }
        });
    });
</script>
@endsection